/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.dann.graph.drawing.hyperassociativemap;

import com.syncleus.dann.UnexpectedDannError;
import com.syncleus.dann.UnexpectedInterruptedException;
import com.syncleus.dann.graph.Graph;
import com.syncleus.dann.graph.TraversableCloud;
import com.syncleus.dann.graph.Weighted;
import com.syncleus.dann.graph.drawing.GraphDrawer;
import com.syncleus.dann.math.Vector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class HyperassociativeMap<G extends Graph<N, ?>, N>
implements GraphDrawer<G, N> {
    private static final double REPULSIVE_WEAKNESS = 2.0;
    private static final double ATTRACTION_STRENGTH = 4.0;
    private static final double DEFAULT_LEARNING_RATE = 0.4;
    private static final double DEFAULT_MAX_MOVEMENT = 0.0;
    private static final double DEFAULT_TOTAL_MOVEMENT = 0.0;
    private static final double DEFAULT_ACCEPTABLE_DISTANCE_FACTOR = 2.0;
    private static final double EQUILIBRIUM_DISTANCE = 2.5;
    private static final double EQUILIBRIUM_ALIGNMENT_FACTOR = 0.005;
    private static final double LEARNING_RATE_INCREASE_FACTOR = 0.9;
    private static final double LEARNING_RATE_PROCESSING_ADJUSTMENT = 1.01;
    private final G graph;
    private final int dimensions;
    private final ExecutorService threadExecutor;
    private Map<N, Vector> coordinates = Collections.synchronizedMap(new HashMap());
    private static final Random RANDOM = new Random();
    private final boolean useWeights;
    private double equilibriumDistance;
    private double learningRate = 0.4;
    private double maxMovement = 0.0;
    private double totalMovement = 0.0;
    private double acceptableDistanceFactor = 2.0;
    private final boolean DEBUG = false;

    private void debug(String msg) {
    }

    private void warn(String msg, Exception ex) {
        System.out.println("WARN" + msg);
    }

    private void error(String msg, Exception ex) {
        System.err.println(msg);
    }

    public HyperassociativeMap(G graph, int dimensions, double equilibriumDistance, boolean useWeights, ExecutorService threadExecutor) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph can not be null");
        }
        if (dimensions <= 0) {
            throw new IllegalArgumentException("dimensions must be 1 or more");
        }
        this.graph = graph;
        this.dimensions = dimensions;
        this.threadExecutor = threadExecutor;
        this.equilibriumDistance = equilibriumDistance;
        this.useWeights = useWeights;
        for (Object node : this.graph.getNodes()) {
            this.coordinates.put(node, HyperassociativeMap.randomCoordinates(this.dimensions));
        }
    }

    public HyperassociativeMap(G graph, int dimensions, ExecutorService threadExecutor) {
        this(graph, dimensions, 2.5, true, threadExecutor);
    }

    public HyperassociativeMap(G graph, int dimensions, double equilibriumDistance, boolean useWeights) {
        this(graph, dimensions, equilibriumDistance, useWeights, null);
    }

    public HyperassociativeMap(G graph, int dimensions) {
        this(graph, dimensions, 2.5, true, null);
    }

    @Override
    public G getGraph() {
        return this.graph;
    }

    public double getEquilibriumDistance() {
        return this.equilibriumDistance;
    }

    public void setEquilibriumDistance(double equilibriumDistance) {
        this.equilibriumDistance = equilibriumDistance;
    }

    public void resetLearning() {
        this.learningRate = 0.4;
        this.maxMovement = 0.0;
        this.totalMovement = 0.0;
        this.acceptableDistanceFactor = 2.0;
    }

    @Override
    public void reset() {
        this.resetLearning();
        for (N node : this.coordinates.keySet()) {
            this.coordinates.put(node, HyperassociativeMap.randomCoordinates(this.dimensions));
        }
    }

    @Override
    public boolean isAlignable() {
        return true;
    }

    public String alignedMetrics() {
        double needsBePos1 = 0.005 * this.equilibriumDistance - this.maxMovement;
        double needsBePos2 = this.maxMovement - 0.0;
        return "BOTH +ive?: " + needsBePos1 + ", " + needsBePos2;
    }

    @Override
    public boolean isAligned() {
        return this.isAlignable() && this.maxMovement < 0.005 * this.equilibriumDistance && this.maxMovement > 0.0;
    }

    private double getAverageMovement() {
        return this.totalMovement / (double)this.graph.getNodes().size();
    }

    @Override
    public void align() {
        Vector center;
        if (!this.coordinates.keySet().equals(this.graph.getNodes())) {
            HashMap newCoordinates = new HashMap();
            for (Object node : this.graph.getNodes()) {
                if (this.coordinates.containsKey(node)) {
                    newCoordinates.put(node, this.coordinates.get(node));
                    continue;
                }
                newCoordinates.put(node, HyperassociativeMap.randomCoordinates(this.dimensions));
            }
            this.coordinates = Collections.synchronizedMap(newCoordinates);
        }
        this.totalMovement = 0.0;
        this.maxMovement = 0.0;
        if (this.threadExecutor == null) {
            center = this.processLocally();
        } else {
            List<Future<Vector>> futures = this.submitFutureAligns();
            try {
                center = this.waitAndProcessFutures(futures);
            }
            catch (InterruptedException caught) {
                this.warn("waitAndProcessFutures was unexpectedly interrupted", caught);
                throw new UnexpectedInterruptedException("Unexpected interruption. Get should block indefinitely", caught);
            }
        }
        this.debug("maxMove: " + this.maxMovement + ", Average Move: " + this.getAverageMovement());
        for (int dimensionIndex = 1; dimensionIndex <= this.dimensions; ++dimensionIndex) {
            center = center.setCoordinate(center.getCoordinate(dimensionIndex) / (double)this.graph.getNodes().size(), dimensionIndex);
        }
        this.recenterNodes(center);
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public Map<N, Vector> getCoordinates() {
        return Collections.unmodifiableMap(this.coordinates);
    }

    private void recenterNodes(Vector center) {
        for (Object node : this.graph.getNodes()) {
            this.coordinates.put(node, this.coordinates.get(node).calculateRelativeTo(center));
        }
    }

    public boolean isUsingWeights() {
        return this.useWeights;
    }

    Map<N, Double> getNeighbors(N nodeToQuery) {
        HashMap neighbors = new HashMap();
        for (TraversableCloud neighborEdge : this.graph.getAdjacentEdges(nodeToQuery)) {
            Double currentWeight = neighborEdge instanceof Weighted && this.useWeights ? ((Weighted)((Object)neighborEdge)).getWeight() : this.equilibriumDistance;
            for (Object neighbor : neighborEdge.getNodes()) {
                if (neighbor.equals(nodeToQuery)) continue;
                neighbors.put(neighbor, currentWeight);
            }
        }
        return neighbors;
    }

    private Vector align(N nodeToAlign) {
        Vector oldLocation;
        Vector location = this.coordinates.get(nodeToAlign);
        Map<N, Double> neighbors = this.getNeighbors(nodeToAlign);
        Vector compositeVector = new Vector(location.getDimensions());
        for (Map.Entry<N, Double> neighborEntry : neighbors.entrySet()) {
            double newDistance;
            N neighbor = neighborEntry.getKey();
            double associationEquilibriumDistance = neighborEntry.getValue();
            Vector neighborVector = this.coordinates.get(neighbor).calculateRelativeTo(location);
            if (Math.abs(neighborVector.getDistance()) > associationEquilibriumDistance) {
                newDistance = Math.pow(Math.abs(neighborVector.getDistance()) - associationEquilibriumDistance, 4.0);
                if (Math.abs(newDistance) > Math.abs(Math.abs(neighborVector.getDistance()) - associationEquilibriumDistance)) {
                    newDistance = Math.copySign(Math.abs(Math.abs(neighborVector.getDistance()) - associationEquilibriumDistance), newDistance);
                }
                neighborVector = neighborVector.setDistance(Math.signum(neighborVector.getDistance()) * (newDistance *= this.learningRate));
            } else {
                newDistance = -2.5 * HyperassociativeMap.atanh((associationEquilibriumDistance - Math.abs(neighborVector.getDistance())) / associationEquilibriumDistance);
                if (Math.abs(newDistance) > Math.abs(associationEquilibriumDistance - Math.abs(neighborVector.getDistance()))) {
                    newDistance = -2.5 * (associationEquilibriumDistance - Math.abs(neighborVector.getDistance()));
                }
                neighborVector = neighborVector.setDistance(Math.signum(neighborVector.getDistance()) * (newDistance *= this.learningRate));
            }
            compositeVector = compositeVector.add(neighborVector);
        }
        for (Map.Entry<Object, Double> node : this.graph.getNodes()) {
            if (neighbors.containsKey(node) || node == nodeToAlign || this.graph.getAdjacentNodes(node).contains(nodeToAlign)) continue;
            Vector nodeVector = this.coordinates.get(node).calculateRelativeTo(location);
            double newDistance = -2.5 / Math.pow(nodeVector.getDistance(), 2.0);
            if (Math.abs(newDistance) > Math.abs(this.equilibriumDistance)) {
                newDistance = Math.copySign(this.equilibriumDistance, newDistance);
            }
            nodeVector = nodeVector.setDistance(newDistance *= this.learningRate);
            compositeVector = compositeVector.add(nodeVector);
        }
        Vector newLocation = location.add(compositeVector);
        double moveDistance = Math.abs(newLocation.calculateRelativeTo(oldLocation = this.coordinates.get(nodeToAlign)).getDistance());
        if (moveDistance > this.equilibriumDistance * this.acceptableDistanceFactor) {
            double newLearningRate = this.equilibriumDistance * this.acceptableDistanceFactor / moveDistance;
            if (newLearningRate < this.learningRate) {
                this.learningRate = newLearningRate;
                this.debug("learning rate: " + this.learningRate);
            } else {
                this.learningRate *= 0.9;
                this.debug("learning rate: " + this.learningRate);
            }
            newLocation = oldLocation;
            moveDistance = 0.0;
        }
        if (moveDistance > this.maxMovement) {
            this.maxMovement = moveDistance;
        }
        this.totalMovement += moveDistance;
        this.coordinates.put(nodeToAlign, newLocation);
        return newLocation;
    }

    public static Vector randomCoordinates(int dimensions) {
        double[] randomCoordinates = new double[dimensions];
        for (int randomCoordinatesIndex = 0; randomCoordinatesIndex < dimensions; ++randomCoordinatesIndex) {
            randomCoordinates[randomCoordinatesIndex] = RANDOM.nextDouble() * 2.0 - 1.0;
        }
        return new Vector(randomCoordinates);
    }

    private static double atanh(double value) {
        return Math.log(Math.abs((value + 1.0) / (1.0 - value))) / 2.0;
    }

    private List<Future<Vector>> submitFutureAligns() {
        ArrayList<Future<Vector>> futures = new ArrayList<Future<Vector>>();
        for (Object node : this.graph.getNodes()) {
            futures.add(this.threadExecutor.submit(new Align(node)));
        }
        return futures;
    }

    private Vector processLocally() {
        Vector pointSum = new Vector(this.dimensions);
        for (Object node : this.graph.getNodes()) {
            Vector newPoint = this.align(node);
            for (int dimensionIndex = 1; dimensionIndex <= this.dimensions; ++dimensionIndex) {
                pointSum = pointSum.setCoordinate(pointSum.getCoordinate(dimensionIndex) + newPoint.getCoordinate(dimensionIndex), dimensionIndex);
            }
        }
        if (this.learningRate * 1.01 < 0.4) {
            double acceptableDistanceAdjustment = 0.1;
            if (this.getAverageMovement() < this.equilibriumDistance * this.acceptableDistanceFactor * 0.1) {
                this.acceptableDistanceFactor *= 0.9;
            }
            this.learningRate *= 1.01;
            this.debug("learning rate: " + this.learningRate + ", acceptableDistanceFactor: " + this.acceptableDistanceFactor);
        }
        return pointSum;
    }

    private Vector waitAndProcessFutures(List<Future<Vector>> futures) throws InterruptedException {
        Vector pointSum = new Vector(this.dimensions);
        try {
            for (Future<Vector> future : futures) {
                Vector newPoint = future.get();
                for (int dimensionIndex = 1; dimensionIndex <= this.dimensions; ++dimensionIndex) {
                    pointSum = pointSum.setCoordinate(pointSum.getCoordinate(dimensionIndex) + newPoint.getCoordinate(dimensionIndex), dimensionIndex);
                }
            }
        }
        catch (ExecutionException caught) {
            this.error("Align had an unexpected problem executing.", caught);
            throw new UnexpectedDannError("Unexpected execution exception. Get should block indefinitely", caught);
        }
        if (this.learningRate * 1.01 < 0.4) {
            double acceptableDistanceAdjustment = 0.1;
            if (this.getAverageMovement() < this.equilibriumDistance * this.acceptableDistanceFactor * 0.1) {
                this.acceptableDistanceFactor = this.maxMovement * 2.0;
            }
            this.learningRate *= 1.01;
            this.debug("learning rate: " + this.learningRate + ", acceptableDistanceFactor: " + this.acceptableDistanceFactor);
        }
        return pointSum;
    }

    private class Align
    implements Callable<Vector> {
        private final N node;

        public Align(N node) {
            this.node = node;
        }

        @Override
        public Vector call() {
            return HyperassociativeMap.this.align(this.node);
        }
    }
}

