/*
 * Decompiled with CFR 0.152.
 */
package au.com.seasoft.ham;

import au.com.seasoft.ham.InteropEdge;
import au.com.seasoft.ham.InteropNode;
import com.syncleus.dann.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GenericGraph
implements Graph {
    private Set<InteropNode> nodes = new HashSet<InteropNode>();
    private Set<InteropEdge> edges = new HashSet<InteropEdge>();

    private GenericGraph() {
    }

    public static GenericGraph create() {
        return new GenericGraph();
    }

    public void addNode(InteropNode node) {
        this.nodes.add(node);
    }

    public void addEdge(InteropEdge edge) {
        this.edges.add(edge);
    }

    public Set getNodes() {
        return this.nodes;
    }

    public Set getEdges() {
        return this.edges;
    }

    public List getAdjacentNodes(Object obj) {
        ArrayList<InteropNode> result = new ArrayList<InteropNode>();
        InteropNode node = (InteropNode)obj;
        for (InteropEdge edge : this.edges) {
            if (edge.getSourceNode().getId() == node.getId()) {
                result.add(edge.getTargetNode());
            }
            if (edge.getTargetNode().getId() != node.getId()) continue;
            result.add(edge.getSourceNode());
        }
        return result;
    }

    public Set getAdjacentEdges(Object obj) {
        HashSet<InteropEdge> result = new HashSet<InteropEdge>();
        InteropNode node = (InteropNode)obj;
        for (InteropEdge edge : this.edges) {
            if (edge.getSourceNode().getId() == node.getId()) {
                result.add(edge);
            }
            if (edge.getTargetNode().getId() != node.getId()) continue;
            result.add(edge);
        }
        return result;
    }

    public List getTraversableNodes(Object obj) {
        ArrayList<InteropNode> result = new ArrayList<InteropNode>();
        InteropNode node = (InteropNode)obj;
        for (InteropEdge edge : this.edges) {
            if (edge.getSourceNode().getId() != node.getId()) continue;
            result.add(edge.getTargetNode());
        }
        return result;
    }

    public Set getTraversableEdges(Object obj) {
        HashSet<InteropEdge> result = new HashSet<InteropEdge>();
        InteropNode node = (InteropNode)obj;
        for (InteropEdge edge : this.edges) {
            if (edge.getSourceNode().getId() != node.getId()) continue;
            result.add(edge);
        }
        return result;
    }
}

