(ns citizen.os)

(def ^:private raw-os (System/getProperty "os.name"))

(def linux? (.startsWith ^String raw-os "Linux"))
(def mac? (.startsWith ^String raw-os "Mac"))
(def windows? (.startsWith ^String raw-os "Windows"))
(def unix? (not windows?)) ;Pretty dumb assumption

(def os
  (let [all {:linux linux? :mac mac? :unix unix? :windows windows?}]
    (into #{} (keys (into {} (filter (comp true? val) all))))))

(defn with-os [os body]
  (case os
    :linux (cond linux? body)
    :mac (cond mac? body)
    :windows (cond windows? body)
    :unix (cond unix? body)
    nil))

(defn with-os-linux [body]
  (with-os :linux body))

(defn with-os-mac [body]
  (with-os :mac body))

(defn with-os-windows [body]
  (with-os :windows body))

(defn with-os-unix [body]
  (with-os :unix body))
