# OS

**OS** is a clojure library with useful Operating System specific utilities.

## Example
```clojure
(ns foo (:use [citizen.os]))

; *Linux
(with-linux (println "linux"))
(with-os :linux (println "linux")) ;Accepts :linux, :nux
(cond linux? (println "linux"))

; Mac
(with-mac (println "mac"))
(with-os :mac (println "mac")) ;Accepts :mac, :osx, :darwin
(cond mac? (println "mac"))

; Unix
(with-unix (println "unix"))
(with-os :unix (println "unix")) ;Accepts :unix, :nix
(cond unix? (println "unix"))

; Windows
(with-windows (println "windows"))
(with-os :windows (println "windows")) ;Accepts :win, :windows
(cond windows? (println "windows"))
```

## Get involved
Contributions are accepted via [issues][issues] or [pull requests][pr]. Please
submit tests with any code you contribute or it won't be considered ready to
merge. If you aren't sure how to go about testing your changes, or if you have
any other questions, [just ask][issues].

### License
The content of this library is released under the **Mozilla Public License 2.0**
by [**Andrew Lawson**](http://adlawson.com). You can find a copy of this license
in [`LICENSE`](LICENSE) or at https://www.mozilla.org/MPL/2.0. If you have any
questions about the licensing, [just ask][issues-license].

[pr]: https://github.com/citizen-ci/clojure-os/pulls
[issues]: https://github.com/citizen-ci/clojure-os/issues
[issues-license]: https://github.com/citizen-ci/clojure-os/issues?q=license
