# swot-clj

[![Build Status](https://travis-ci.org/ipavl/swot-clj.svg?branch=master)](https://travis-ci.org/ipavl/swot-clj)
[![Dependency Status](https://www.versioneye.com/user/projects/559365bf6238390015000002/badge.svg?style=flat)](https://www.versioneye.com/user/projects/559365bf6238390015000002)

swot-clj is a Clojure port of [Lee Reilly](https://github.com/leereilly)'s [Swot library](https://github.com/leereilly/swot) to validate email addresses and domains of academic institutions, which is described as follows:

> If you have a product or service and offer **academic discounts**, there's a good chance there's some manual component to the approval process. Perhaps `.edu` email addresses are automatically approved because, for the most part at least, they're associated with American post-secondary educational institutions. Perhaps `.ac.uk` email addresses are automatically approved because they're guaranteed to belong to British universities and colleges. Unfortunately, not every country has an education-specific TLD (Top Level Domain) and plenty of schools use `.com` or `.net`.

> Swot is a community-driven or crowdsourced library for verifying that domain names and email addresses are tied to a legitimate university of college - more specifically, an academic institution providing higher education in tertiary, quaternary or any other kind of post-secondary education in any country in the world.

## Installation

If using Leiningen, add the following to your `project.clj` file under the `:dependencies` section:

[![Clojars Project](http://clojars.org/swot-clj/latest-version.svg)](http://clojars.org/swot-clj)

swot-clj also works from the REPL.

## Usage

The two main functions of swot-clj are:

* `is-academic?` to verify an email address or domain as belonging to a legitimate academic institution
* `get-institution-name` to associate a domain with an institution name

Both functions take a single string argument, representing a domain name or an email address.

### Verify email addresses

    (is-academic? "test@stanford.edu")          ;; true
    (is-academic? "test@strath.ac.uk")          ;; true
    (is-academic? "test@soft-eng.strath.ac.uk") ;; true
    (is-academic? "test@ugr.es")                ;; true
    (is-academic? "test@uottawa.ca")            ;; true
    (is-academic? "test@gmail.com")             ;; false

### Verify domains

    (is-academic? "harvard.edu")             ;; true
    (is-academic? "www.harvard.edu")         ;; true
    (is-academic? "http://www.harvard.edu")  ;; true
    (is-academic? "http://www.github.com")   ;; false
    (is-academic? "http://www.google.co.uk") ;; false

### Find school names

    (get-institution-name "test@cs.strath.ac.uk")
    ;; => ["University of Strathclyde"]
    (get-institution-name "http://www.stanford.edu")
    ;; => ["Stanford University"]

Please see the [Limitations](#limitations) section for known issues and limitations.

## Documentation

Project documentation is generated by [Codox](https://github.com/weavejester/codox) and can be found [on GitHub Pages](https://ipavl.github.io/swot-clj/doc), or generated locally with:

    lein doc

## Contributing

Pull requests are welcome! The [Limitations](#limitations) section below and the issue tracker are good places to start if you're looking for something that needs to be done.

If adding or changing functionality, please add tests for your feature/change if relevant, and make sure that your changes pass the existing tests. Tests can be run locally with `lein test`, and will also be run via Travis CI when you make a pull request.

To add/edit/remove a school, follow the [same guidelines](https://github.com/leereilly/swot/blob/master/CONTRIBUTING.md) as the main Swot library. You should make changes *to Swot itself*, and then submit a request to update swot-clj once your changes are merged upstream so that the two projects can stay roughly in sync.

## Limitations

Like Swot, swot-clj only gives you a high confidence level - *not a guarantee* - that an email address belongs to an individual that is a current student. You should (occasionally) monitor sign ups to verify registrations, particularly if you see a lot of traffic from certain domains.

swot-clj shares the same limitations as Swot:

* You can search by email and domain names only. You cannot search by IP.
* You don't know if the email address belongs to a student, faculty, staff member, alumni, or a contractor.
* There may be a few false positives, missing institutions... maybe even a couple of typos. Contributions welcome!

## License

Copyright © 2015 ipavl

Distributed under the Eclipse Public License either version 1.0 or (at your option) any later version.
