(defproject circleci/statsd "0.1.9"
  :description "Wrapper around clj-statsd"
  :url "github.com/circleci/statsd"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :pedantic? :abort
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.clojure/tools.logging "0.3.1"]
                 [clj-statsd "0.4.0"]]

  :profiles {:uberjar {:aot :all}}

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["deploy"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :repositories [["releases" {:url "https://clojars.org/repo"
                              :username [:gpg :env/clojars_username]
                              :password [:gpg :env/clojars_password]
                              :sign-releases false}]])
