# circleci.statsd

A wrapper around [clj-statsd](https://github.com/pyr/clj-statsd) that provides
a slightly nicer interface for setting metric tags.

## Usage

```clojure
(require '[circleci.statsd :as statsd])

;; configure
(statsd/setup "localhost" 8125)

;; increment a metric
(statsd/increment :foo)

;; increment with tags
(statsd/increment :foo 1 {:tags ["my:tag"]})
```

Similar fns exist for `decrement`, `timing`, `gauge`, and `unique`

## Deploying

### Set up
You will need to be part of the circleci group on clojars. Your clojars
credentials will need to be available also, either via
`~/.lein/credentials.clj.gpg`, the env-vars `CLOJARS_USERNAME` and
`CLOJARS_PASSWORD`, or you can just type them in interactively.

See `lein help deploying` for more info on storing credentials.

### Create a new release
Your checkout must be clean before releasing.

1. `git clean --dry-run`
1. Tidy up whatever `git clean` highlights. To remove everything: `git clean -f`
1. `lein release`

## License

Copyright © 2017 Circle Internet Services
