/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interop;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interop.Creator;
import org.keyczar.interop.Generator;
import org.keyczar.interop.InteropCommand;
import org.keyczar.interop.Tester;

public class Interop {
    public static void main(String[] args) {
        BasicConfigurator.configure((Appender)new NullAppender());
        Gson gson = new Gson();
        switch (Interop.getCommandType(args[0])) {
            case GENERATE: {
                Generator generator = (Generator)gson.fromJson(args[0], Generator.class);
                try {
                    String output = generator.generate();
                    if (output == null) break;
                    System.out.print(output);
                }
                catch (KeyczarException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case CREATE: {
                Creator creator = (Creator)gson.fromJson(args[0], Creator.class);
                creator.create();
                break;
            }
            case TEST: {
                Tester tester = (Tester)gson.fromJson(args[0], Tester.class);
                try {
                    tester.test();
                }
                catch (KeyczarException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            default: {
                System.out.println("No such command");
                System.exit(1);
            }
        }
    }

    private static InteropCommand getCommandType(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonObject object = parser.parse(jsonString).getAsJsonObject();
        return InteropCommand.getCommand(object.get("command").getAsString());
    }
}

