/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interfaces;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyczarKey;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.keyparams.KeyParameters;

public interface KeyType {
    public String validateKeyParameters(KeyParameters var1) throws KeyczarException;

    public KeyParameters applyDefaultParameters(KeyParameters var1);

    public String getName();

    public Builder getBuilder();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyTypeDeserializer
    implements JsonDeserializer<KeyType> {
        private static Map<String, KeyType> typeMap = new HashMap<String, KeyType>();

        public static void registerType(KeyType keyType) {
            String name = keyType.getName();
            if (typeMap.containsKey(name)) {
                throw new IllegalArgumentException("Attempt to map two key types to the same name " + name);
            }
            typeMap.put(name, keyType);
        }

        public KeyType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            String keyName = json.getAsJsonPrimitive().getAsString();
            if (!typeMap.containsKey(keyName)) {
                throw new IllegalArgumentException("Cannot deserialize " + keyName + " no such key has been registered.");
            }
            return typeMap.get(keyName);
        }

        static {
            for (DefaultKeyType key : DefaultKeyType.values()) {
                KeyTypeDeserializer.registerType(key);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyTypeSerializer
    implements JsonSerializer<KeyType> {
        public JsonElement serialize(KeyType src, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(src.getName());
        }
    }

    public static interface Builder {
        public KeyczarKey read(String var1) throws KeyczarException;

        public KeyczarKey generate(KeyParameters var1) throws KeyczarException;
    }
}

