/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.keyczar.DefaultKeyType;
import org.keyczar.DsaPublicKey;
import org.keyczar.KeyMetadata;
import org.keyczar.KeyVersion;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.RsaPublicKey;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.enums.RsaPadding;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;

public class X509CertificateReader
implements KeyczarReader {
    private final InputStream certificateStream;
    private final KeyPurpose purpose;
    private final RsaPadding padding;
    private KeyMetadata meta = null;
    private KeyczarPublicKey key;

    public X509CertificateReader(KeyPurpose purpose, InputStream certificateStream, RsaPadding padding) throws KeyczarException {
        if (purpose == null) {
            throw new KeyczarException("X509Certificate purpose must not be null");
        }
        if (certificateStream == null) {
            throw new KeyczarException("X509Certificate stream must not be null");
        }
        this.purpose = purpose;
        this.certificateStream = certificateStream;
        this.padding = padding;
    }

    public String getKey(int version) throws KeyczarException {
        this.ensureCertificateRead();
        return this.key.toString();
    }

    public String getKey() throws KeyczarException {
        this.ensureCertificateRead();
        return this.key.toString();
    }

    public String getMetadata() throws KeyczarException {
        this.ensureCertificateRead();
        return this.meta.toString();
    }

    private void ensureCertificateRead() throws KeyczarException {
        if (this.key == null) {
            try {
                this.parseCertificate();
                this.constructMetadata();
            }
            catch (CertificateException e) {
                throw new KeyczarException(Messages.getString("KeyczarTool.InvalidCertificate", new Object[0]), e);
            }
        }
    }

    private void constructMetadata() throws KeyczarException {
        if (this.purpose == KeyPurpose.ENCRYPT && this.key.getType() == DefaultKeyType.DSA_PUB) {
            throw new KeyczarException(Messages.getString("Keyczartool.InvalidUseOfDsaKey", new Object[0]));
        }
        this.meta = new KeyMetadata("imported from certificate", this.purpose, this.key.getType());
        this.meta.addVersion(new KeyVersion(1, KeyStatus.PRIMARY, true));
    }

    private void parseCertificate() throws CertificateException, KeyczarException {
        Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(this.certificateStream);
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            this.key = new RsaPublicKey((RSAPublicKey)publicKey, this.padding);
        } else if (publicKey instanceof DSAPublicKey) {
            if (this.padding != null) {
                throw new KeyczarException(Messages.getString("InvalidPadding", this.padding.name()));
            }
            this.key = new DsaPublicKey((DSAPublicKey)publicKey);
        } else {
            throw new KeyczarException("Unrecognized key type " + publicKey.getAlgorithm() + " in certificate");
        }
    }
}

