/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.keyczar.Keyczar;
import org.keyczar.KeyczarKey;
import org.keyczar.StreamCache;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;

public class UnversionedVerifier
extends Keyczar {
    private static final Logger LOG = Logger.getLogger(UnversionedVerifier.class);
    private static final StreamCache<VerifyingStream> VERIFY_CACHE = new StreamCache();

    public UnversionedVerifier(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    public UnversionedVerifier(String fileLocation) throws KeyczarException {
        super(fileLocation);
    }

    public boolean verify(byte[] data, byte[] signature) throws KeyczarException {
        return this.verify(ByteBuffer.wrap(data), ByteBuffer.wrap(signature));
    }

    public boolean verify(ByteBuffer data, ByteBuffer signature) throws KeyczarException {
        LOG.debug((Object)Messages.getString("UnversionedVerifier.Verifying", data.remaining()));
        for (KeyczarKey key : this.versionMap.values()) {
            if (!this.verify(data, signature, key)) continue;
            return true;
        }
        return false;
    }

    private boolean verify(ByteBuffer data, ByteBuffer signature, KeyczarKey key) throws KeyczarException {
        boolean foundValidSignature;
        VerifyingStream stream = VERIFY_CACHE.get(key);
        if (stream == null) {
            stream = (VerifyingStream)key.getStream();
        }
        try {
            stream.initVerify();
            stream.updateVerify(data.duplicate());
            foundValidSignature = stream.verify(signature.duplicate());
            VERIFY_CACHE.put(key, stream);
        }
        catch (KeyczarException e) {
            foundValidSignature = false;
        }
        return foundValidSignature;
    }

    public boolean verify(String data, String signature) throws KeyczarException {
        try {
            return this.verify(data.getBytes("UTF-8"), Base64Coder.decodeWebSafe(signature));
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyczarException(e);
        }
    }

    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return purpose == KeyPurpose.VERIFY || purpose == KeyPurpose.SIGN_AND_VERIFY;
    }
}

