/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.keyczar.Signer;
import org.keyczar.TimeoutVerifier;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.util.Base64Coder;

public class TimeoutSigner
extends TimeoutVerifier {
    private Signer signer;

    public TimeoutSigner(KeyczarReader reader) throws KeyczarException {
        this.signer = new Signer(reader);
        this.setVerifier(this.signer);
    }

    public TimeoutSigner(String fileLocation) throws KeyczarException {
        this.signer = new Signer(fileLocation);
        this.setVerifier(this.signer);
    }

    public TimeoutSigner(Signer signer) {
        this.signer = signer;
        this.setVerifier(this.signer);
    }

    public String timeoutSign(String input, long expirationTime) throws KeyczarException {
        try {
            return Base64Coder.encodeWebSafe(this.timeoutSign(input.getBytes("UTF-8"), expirationTime));
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyczarException(e);
        }
    }

    public byte[] timeoutSign(byte[] input, long expirationTime) throws KeyczarException {
        ByteBuffer output = ByteBuffer.allocate(this.signer.digestSize() + 8);
        this.timeoutSign(ByteBuffer.wrap(input), expirationTime, output);
        output.reset();
        byte[] outputBytes = new byte[output.remaining()];
        output.get(outputBytes);
        return outputBytes;
    }

    public void timeoutSign(ByteBuffer input, long expirationTime, ByteBuffer output) throws KeyczarException {
        this.signer.sign(input, null, expirationTime, output);
    }
}

