/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import org.keyczar.AesKey;
import org.keyczar.Crypter;
import org.keyczar.ImportedKeyReader;
import org.keyczar.SessionMaterial;
import org.keyczar.Verifier;
import org.keyczar.annotations.Experimental;
import org.keyczar.exceptions.Base64DecodingException;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.util.Base64Coder;

@Experimental
public class SignedSessionDecrypter {
    private final SessionMaterial session;
    private final Verifier verifier;

    public SignedSessionDecrypter(Crypter crypter, Verifier verifier, String session) throws Base64DecodingException, KeyczarException {
        this.verifier = verifier;
        byte[] decoded = Base64Coder.decodeWebSafe(session);
        String sessionString = new String(crypter.decrypt(decoded));
        this.session = SessionMaterial.read(sessionString);
    }

    public byte[] decrypt(byte[] signedBlob) throws KeyczarException {
        if (null == this.session) {
            throw new KeyczarException("Session has not been initialized");
        }
        AesKey aesKey = this.session.getKey();
        ImportedKeyReader importedKeyReader = new ImportedKeyReader(aesKey);
        Crypter symmetricCrypter = new Crypter(importedKeyReader);
        byte[] ciphertext = this.verifier.getAttachedData(signedBlob, Base64Coder.decodeWebSafe(this.session.getNonce()));
        return symmetricCrypter.decrypt(ciphertext);
    }
}

