/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import org.keyczar.AesKey;
import org.keyczar.annotations.Experimental;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.util.Util;

@Experimental
public class SessionMaterial {
    @Expose
    private AesKey key = null;
    @Expose
    private String nonce = "";

    public SessionMaterial() {
    }

    public SessionMaterial(AesKey key, String nonce) {
        this.key = key;
        this.nonce = nonce;
    }

    public AesKey getKey() throws KeyczarException {
        if (null == this.key) {
            throw new KeyczarException("Key has not been initialized");
        }
        return this.key;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String toString() {
        return Util.gson().toJson((Object)this);
    }

    public static SessionMaterial read(String sessionString) {
        return (SessionMaterial)Util.gson().fromJson(sessionString, SessionMaterial.class);
    }
}

