/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.enums.RsaPadding;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.UnsupportedTypeException;
import org.keyczar.interfaces.EncryptingStream;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Util;

public class RsaPublicKey
extends KeyczarPublicKey {
    private static final String KEY_GEN_ALGORITHM = "RSA";
    private static final String SIG_ALGORITHM = "SHA1withRSA";
    private RSAPublicKey jcePublicKey;
    @Expose
    final String modulus;
    @Expose
    final String publicExponent;
    @Expose
    final RsaPadding padding;
    private final byte[] hash = new byte[4];

    static RsaPublicKey read(String input) throws KeyczarException {
        RsaPublicKey key = (RsaPublicKey)Util.gson().fromJson(input, RsaPublicKey.class);
        if (key.getType() != DefaultKeyType.RSA_PUB) {
            throw new UnsupportedTypeException(key.getType());
        }
        return key.initFromJson();
    }

    public byte[] hash() {
        return this.hash;
    }

    protected Stream getStream() throws KeyczarException {
        return new RsaStream();
    }

    public KeyType getType() {
        return DefaultKeyType.RSA_PUB;
    }

    RsaPublicKey(RSAPrivateCrtKey privateKey, RsaPadding padding) throws KeyczarException {
        this(privateKey.getModulus(), privateKey.getPublicExponent(), padding);
        this.initializeJceKey(privateKey.getModulus(), privateKey.getPublicExponent());
        this.initializeHash();
    }

    RsaPublicKey(RSAPublicKey publicKey, RsaPadding padding) throws KeyczarException {
        this(publicKey.getModulus(), publicKey.getPublicExponent(), padding);
        this.jcePublicKey = publicKey;
        this.initializeHash();
    }

    private RsaPublicKey() {
        super(0);
        this.publicExponent = null;
        this.modulus = null;
        this.padding = null;
    }

    private RsaPublicKey(BigInteger mod, BigInteger exp, RsaPadding padding) {
        super(mod.bitLength());
        this.modulus = Util.encodeBigInteger(mod);
        this.publicExponent = Util.encodeBigInteger(exp);
        this.padding = padding == RsaPadding.PKCS ? RsaPadding.PKCS : null;
    }

    RsaPublicKey initFromJson() throws KeyczarException {
        this.initializeJceKey(Util.decodeBigInteger(this.modulus), Util.decodeBigInteger(this.publicExponent));
        this.initializeHash();
        return this;
    }

    private void initializeJceKey(BigInteger publicModulus, BigInteger publicExponent) throws KeyczarException {
        try {
            RSAPublicKeySpec spec = new RSAPublicKeySpec(publicModulus, publicExponent);
            this.jcePublicKey = (RSAPublicKey)KeyFactory.getInstance(KEY_GEN_ALGORITHM).generatePublic(spec);
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    private void initializeHash() throws KeyczarException {
        System.arraycopy(this.getPadding().computeFullHash(this.jcePublicKey), 0, this.hash, 0, this.hash.length);
    }

    int keySizeInBytes() {
        return this.jcePublicKey.getModulus().bitLength() / 8;
    }

    protected RSAPublicKey getJceKey() {
        return this.jcePublicKey;
    }

    protected boolean isSecret() {
        return false;
    }

    public RsaPadding getPadding() {
        if (this.padding == null || this.padding == RsaPadding.OAEP) {
            return RsaPadding.OAEP;
        }
        return RsaPadding.PKCS;
    }

    private class RsaStream
    implements VerifyingStream,
    EncryptingStream {
        private Cipher cipher;
        private Signature signature;

        RsaStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(RsaPublicKey.SIG_ALGORITHM);
                this.cipher = Cipher.getInstance(RsaPublicKey.this.getPadding().getCryptAlgorithm());
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int digestSize() {
            return RsaPublicKey.this.keySizeInBytes();
        }

        public int doFinalEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                int ciphertextSize = this.cipher.getOutputSize(input.limit());
                int outputCapacity = output.limit() - output.position();
                ByteBuffer tmpOutput = ByteBuffer.allocate(ciphertextSize);
                this.cipher.doFinal(input, tmpOutput);
                if (ciphertextSize == outputCapacity) {
                    output.put(tmpOutput.array());
                } else if (ciphertextSize == outputCapacity + 1 && tmpOutput.array()[ciphertextSize - 1] == 0) {
                    output.put(tmpOutput.array(), 0, outputCapacity);
                } else {
                    throw new KeyczarException("Expected " + outputCapacity + " bytes from encryption " + "operation but got " + ciphertextSize);
                }
                return outputCapacity;
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public SigningStream getSigningStream() {
            return new SigningStream(){

                public int digestSize() {
                    return 0;
                }

                public void initSign() {
                }

                public void sign(ByteBuffer output) {
                }

                public void updateSign(ByteBuffer input) {
                }
            };
        }

        public int initEncrypt(ByteBuffer output) throws KeyczarException {
            try {
                this.cipher.init(1, RsaPublicKey.this.jcePublicKey);
            }
            catch (InvalidKeyException e) {
                throw new KeyczarException(e);
            }
            return 0;
        }

        public void initVerify() throws KeyczarException {
            try {
                this.signature.initVerify(RsaPublicKey.this.jcePublicKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int maxOutputSize(int inputLen) {
            return RsaPublicKey.this.keySizeInBytes();
        }

        public int updateEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.update(input, output);
            }
            catch (ShortBufferException e) {
                throw new KeyczarException(e);
            }
        }

        public void updateVerify(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        public boolean verify(ByteBuffer sig) throws KeyczarException {
            try {
                return this.signature.verify(sig.array(), sig.position(), sig.limit() - sig.position());
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }
    }
}

