/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.RsaPublicKey;
import org.keyczar.enums.RsaPadding;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.DecryptingStream;
import org.keyczar.interfaces.EncryptingStream;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.keyparams.RsaKeyParameters;
import org.keyczar.util.Util;

public class RsaPrivateKey
extends KeyczarKey
implements KeyczarPrivateKey {
    private static final String KEY_GEN_ALGORITHM = "RSA";
    @Expose
    private final RsaPublicKey publicKey;
    @Expose
    private final String privateExponent;
    @Expose
    private final String primeP;
    @Expose
    private final String primeQ;
    @Expose
    private final String primeExponentP;
    @Expose
    private final String primeExponentQ;
    @Expose
    private final String crtCoefficient;
    private static final String SIG_ALGORITHM = "SHA1withRSA";
    private RSAPrivateCrtKey jcePrivateKey;

    static RsaPrivateKey generate(RsaKeyParameters params) throws KeyczarException {
        KeyPair keyPair = Util.generateKeyPair(KEY_GEN_ALGORITHM, params.getKeySize());
        return new RsaPrivateKey((RSAPrivateCrtKey)keyPair.getPrivate(), params.getRsaPadding() == null ? RsaPadding.OAEP : params.getRsaPadding());
    }

    static RsaPrivateKey read(String input) throws KeyczarException {
        RsaPrivateKey key = (RsaPrivateKey)Util.gson().fromJson(input, RsaPrivateKey.class);
        return key.initFromJson();
    }

    public RsaPrivateKey(RSAPrivateCrtKey privateKey, RsaPadding padding) throws KeyczarException {
        super(privateKey.getModulus().bitLength());
        this.publicKey = new RsaPublicKey(privateKey, padding);
        this.privateExponent = Util.encodeBigInteger(privateKey.getPrivateExponent());
        this.primeP = Util.encodeBigInteger(privateKey.getPrimeP());
        this.primeQ = Util.encodeBigInteger(privateKey.getPrimeQ());
        this.primeExponentP = Util.encodeBigInteger(privateKey.getPrimeExponentP());
        this.primeExponentQ = Util.encodeBigInteger(privateKey.getPrimeExponentQ());
        this.crtCoefficient = Util.encodeBigInteger(privateKey.getCrtCoefficient());
        this.jcePrivateKey = privateKey;
    }

    private RsaPrivateKey() {
        super(0);
        this.publicKey = null;
        this.privateExponent = null;
        this.primeP = null;
        this.primeQ = null;
        this.primeExponentP = null;
        this.primeExponentQ = null;
        this.crtCoefficient = null;
        this.jcePrivateKey = null;
    }

    protected Stream getStream() throws KeyczarException {
        return new RsaPrivateStream();
    }

    public KeyType getType() {
        return DefaultKeyType.RSA_PRIV;
    }

    protected byte[] hash() {
        return this.publicKey.hash();
    }

    public KeyczarPublicKey getPublic() {
        return this.publicKey;
    }

    private RsaPrivateKey initFromJson() throws KeyczarException {
        this.publicKey.initFromJson();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(Util.decodeBigInteger(this.publicKey.modulus), Util.decodeBigInteger(this.publicKey.publicExponent), Util.decodeBigInteger(this.privateExponent), Util.decodeBigInteger(this.primeP), Util.decodeBigInteger(this.primeQ), Util.decodeBigInteger(this.primeExponentP), Util.decodeBigInteger(this.primeExponentQ), Util.decodeBigInteger(this.crtCoefficient));
            this.jcePrivateKey = (RSAPrivateCrtKey)keyFactory.generatePrivate(spec);
            return this;
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    protected RSAPrivateCrtKey getJceKey() {
        return this.jcePrivateKey;
    }

    private class RsaPrivateStream
    implements SigningStream,
    VerifyingStream,
    DecryptingStream,
    EncryptingStream {
        private Cipher cipher;
        private EncryptingStream encryptingStream;
        private Signature signature;
        private VerifyingStream verifyingStream;

        public RsaPrivateStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(RsaPrivateKey.SIG_ALGORITHM);
                this.verifyingStream = (VerifyingStream)RsaPrivateKey.this.publicKey.getStream();
                this.cipher = Cipher.getInstance(RsaPrivateKey.this.publicKey.getPadding().getCryptAlgorithm());
                this.encryptingStream = (EncryptingStream)RsaPrivateKey.this.publicKey.getStream();
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int digestSize() {
            return RsaPrivateKey.this.publicKey.keySizeInBytes();
        }

        public int doFinalDecrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.doFinal(input, output);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int doFinalEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.doFinalEncrypt(input, output);
        }

        public SigningStream getSigningStream() throws KeyczarException {
            return this.encryptingStream.getSigningStream();
        }

        public VerifyingStream getVerifyingStream() {
            return new VerifyingStream(){

                public int digestSize() {
                    return 0;
                }

                public void initVerify() {
                }

                public void updateVerify(ByteBuffer input) {
                }

                public boolean verify(ByteBuffer signature) {
                    return true;
                }
            };
        }

        public void initDecrypt(ByteBuffer input) throws KeyczarException {
            try {
                this.cipher.init(2, RsaPrivateKey.this.jcePrivateKey);
            }
            catch (InvalidKeyException e) {
                throw new KeyczarException(e);
            }
        }

        public int initEncrypt(ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.initEncrypt(output);
        }

        public void initSign() throws KeyczarException {
            try {
                this.signature.initSign(RsaPrivateKey.this.jcePrivateKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public void initVerify() throws KeyczarException {
            this.verifyingStream.initVerify();
        }

        public int maxOutputSize(int inputLen) {
            return RsaPrivateKey.this.publicKey.keySizeInBytes();
        }

        public void sign(ByteBuffer output) throws KeyczarException {
            try {
                byte[] sig = this.signature.sign();
                output.put(sig);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        public int updateDecrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.update(input, output);
            }
            catch (ShortBufferException e) {
                throw new KeyczarException(e);
            }
        }

        public int updateEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.updateEncrypt(input, output);
        }

        public void updateSign(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        public void updateVerify(ByteBuffer input) throws KeyczarException {
            this.verifyingStream.updateVerify(input);
        }

        public boolean verify(ByteBuffer sig) throws KeyczarException {
            return this.verifyingStream.verify(sig);
        }
    }
}

