/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.util.HashMap;
import org.keyczar.DefaultKeyType;
import org.keyczar.HmacKey;
import org.keyczar.enums.Flag;
import org.keyczar.enums.RsaPadding;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.keyparams.AesKeyParameters;
import org.keyczar.keyparams.RsaKeyParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyczarToolKeyParameters
implements AesKeyParameters,
RsaKeyParameters {
    private final HashMap<Flag, String> flagMap;

    public KeyczarToolKeyParameters(HashMap<Flag, String> flagMap) {
        this.flagMap = flagMap;
    }

    @Override
    public RsaPadding getRsaPadding() throws KeyczarException {
        String paddingFlag = this.flagMap.get((Object)Flag.PADDING);
        try {
            if (paddingFlag != null) {
                return RsaPadding.valueOf(paddingFlag.toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            throw new KeyczarException(Messages.getString("InvalidPadding", paddingFlag));
        }
        return null;
    }

    @Override
    public int getKeySize() throws KeyczarException {
        if (this.flagMap.containsKey((Object)Flag.SIZE)) {
            try {
                return Integer.parseInt(this.flagMap.get((Object)Flag.SIZE));
            }
            catch (NumberFormatException e) {
                throw new KeyczarException("Error parsing key size", e);
            }
        }
        return -1;
    }

    @Override
    public HmacKey getHmacKey() throws KeyczarException {
        return HmacKey.generate(DefaultKeyType.HMAC_SHA1.applyDefaultParameters(null));
    }
}

