/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import org.keyczar.Crypter;
import org.keyczar.DefaultKeyType;
import org.keyczar.Encrypter;
import org.keyczar.GenericKeyczar;
import org.keyczar.KeyMetadata;
import org.keyczar.KeyVersion;
import org.keyczar.KeyczarEncryptedReader;
import org.keyczar.KeyczarFileReader;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarToolKeyParameters;
import org.keyczar.MockKeyczarReader;
import org.keyczar.PkcsKeyReader;
import org.keyczar.Signer;
import org.keyczar.X509CertificateReader;
import org.keyczar.enums.Command;
import org.keyczar.enums.Flag;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.enums.RsaPadding;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.keyparams.KeyParameters;

public class KeyczarTool {
    private static MockKeyczarReader mock = null;

    public static void setReader(MockKeyczarReader reader) {
        mock = reader;
    }

    public static MockKeyczarReader getMock() {
        return mock;
    }

    public static void main(String[] args) {
        ArrayList<String> nonFlagArgs = new ArrayList<String>();
        if (args.length == 0) {
            KeyczarTool.printUsage();
        } else {
            try {
                HashMap<Flag, String> flagMap = new HashMap<Flag, String>();
                for (String arg : args) {
                    if (arg.startsWith("--")) {
                        String[] nameValuePair = (arg = arg.substring(2)).split("=");
                        if (nameValuePair.length <= 1) continue;
                        Flag f = Flag.getFlag(nameValuePair[0]);
                        flagMap.put(f, nameValuePair[1]);
                        continue;
                    }
                    nonFlagArgs.add(arg);
                }
                String locationFlag = (String)flagMap.get((Object)Flag.LOCATION);
                if (locationFlag != null && !locationFlag.endsWith(File.separator)) {
                    locationFlag = locationFlag + File.separator;
                }
                KeyPurpose purposeFlag = KeyPurpose.getPurpose((String)flagMap.get((Object)Flag.PURPOSE));
                KeyStatus statusFlag = KeyStatus.getStatus((String)flagMap.get((Object)Flag.STATUS));
                String asymmetricFlag = (String)flagMap.get((Object)Flag.ASYMMETRIC);
                String crypterFlag = (String)flagMap.get((Object)Flag.CRYPTER);
                String destinationFlag = (String)flagMap.get((Object)Flag.DESTINATION);
                String nameFlag = (String)flagMap.get((Object)Flag.NAME);
                String paddingFlag = (String)flagMap.get((Object)Flag.PADDING);
                String passphraseFlag = (String)flagMap.get((Object)Flag.PASSPHRASE);
                String pemFileFlag = (String)flagMap.get((Object)Flag.PEMFILE);
                String versionFlag = (String)flagMap.get((Object)Flag.VERSION);
                switch (Command.getCommand((String)nonFlagArgs.get(0))) {
                    case CREATE: {
                        KeyczarTool.create(locationFlag, nameFlag, purposeFlag, asymmetricFlag);
                        break;
                    }
                    case ADDKEY: {
                        KeyczarTool.addKey(locationFlag, statusFlag, crypterFlag, new KeyczarToolKeyParameters(flagMap));
                        break;
                    }
                    case PUBKEY: {
                        KeyczarTool.publicKeys(locationFlag, destinationFlag);
                        break;
                    }
                    case PROMOTE: {
                        KeyczarTool.promote(locationFlag, Integer.parseInt(versionFlag));
                        break;
                    }
                    case DEMOTE: {
                        KeyczarTool.demote(locationFlag, Integer.parseInt(versionFlag));
                        break;
                    }
                    case REVOKE: {
                        KeyczarTool.revoke(locationFlag, Integer.parseInt(versionFlag));
                        break;
                    }
                    case USEKEY: {
                        String message = null;
                        if (nonFlagArgs.size() > 1) {
                            message = (String)nonFlagArgs.get(1);
                        }
                        KeyczarTool.useKey(message, locationFlag, destinationFlag, crypterFlag);
                        break;
                    }
                    case IMPORT_KEY: {
                        KeyczarTool.importKey(locationFlag, pemFileFlag, statusFlag, crypterFlag, paddingFlag, passphraseFlag);
                        break;
                    }
                    case EXPORT_KEY: {
                        KeyczarTool.exportKey(locationFlag, crypterFlag, Integer.parseInt(versionFlag), pemFileFlag, passphraseFlag);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                KeyczarTool.printUsage();
            }
        }
    }

    private static void exportKey(String locationFlag, String crypterFlag, int versionFlag, String pemFileFlag, String passphraseFlag) throws KeyczarException {
        if (versionFlag < 0) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MissingVersion", new Object[0]));
        }
        GenericKeyczar sourceKeyczar = KeyczarTool.createGenericKeyczar(locationFlag, crypterFlag);
        KeyVersion keyVersion = sourceKeyczar.getVersion(versionFlag);
        KeyczarKey key = sourceKeyczar.getKey(keyVersion);
        String pemString = key.getPemString(passphraseFlag);
        try {
            File pemFile = new File(pemFileFlag);
            if (!pemFile.createNewFile()) {
                throw new KeyczarException(Messages.getString("", pemFile));
            }
            FileOutputStream pemFileStream = new FileOutputStream(pemFile);
            pemFileStream.write(pemString.getBytes("UTF8"));
        }
        catch (IOException e) {
            throw new KeyczarException(Messages.getString("", new Object[0]), e);
        }
    }

    private static void importKey(String locationFlag, String pemFileFlag, KeyStatus keyStatus, String crypterFlag, String paddingFlag, String passphraseFlag) throws KeyczarException, IOException {
        GenericKeyczar destinationKeyczar = KeyczarTool.createGenericKeyczar(locationFlag, crypterFlag);
        KeyMetadata destMetadata = destinationKeyczar.getMetadata();
        GenericKeyczar sourceKeyczar = KeyczarTool.getImportingKeyczar(pemFileFlag, paddingFlag, passphraseFlag, destMetadata.getPurpose());
        KeyType sourceKeyType = sourceKeyczar.getMetadata().getType();
        if (destMetadata.getType() != sourceKeyType && destinationKeyczar.getVersions().isEmpty()) {
            destMetadata.setType(sourceKeyType);
        }
        destinationKeyczar.addVersion(keyStatus, sourceKeyczar.getPrimaryKey());
        KeyczarTool.updateGenericKeyczar(destinationKeyczar, crypterFlag, locationFlag);
    }

    private static GenericKeyczar getImportingKeyczar(String pemFileFlag, String paddingFlag, String passphraseFlag, KeyPurpose purpose) throws KeyczarException, IOException {
        RsaPadding padding = KeyczarTool.getPadding(paddingFlag);
        InputStream fileStream = KeyczarTool.getFileStream(pemFileFlag);
        try {
            GenericKeyczar genericKeyczar = new GenericKeyczar(new X509CertificateReader(purpose, fileStream, padding));
            return genericKeyczar;
        }
        catch (KeyczarException e) {
            if (e.getCause() instanceof CertificateException) {
                fileStream.close();
                fileStream = KeyczarTool.getFileStream(pemFileFlag);
                GenericKeyczar genericKeyczar = new GenericKeyczar(new PkcsKeyReader(purpose, fileStream, padding, passphraseFlag));
                return genericKeyczar;
            }
            throw e;
        }
        finally {
            fileStream.close();
        }
    }

    private static InputStream getFileStream(String filePath) throws KeyczarException {
        try {
            return new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new KeyczarException(Messages.getString("KeyczarTool.FileNotFound", filePath));
        }
    }

    private static void useKey(String msg, String locationFlag, String destinationFlag, String crypterFlag) throws KeyczarException, IOException {
        if (msg == null) {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            StringBuilder msgBuilder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                msgBuilder.append(line);
                msgBuilder.append("\n");
            }
            msg = msgBuilder.toString();
        }
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag, crypterFlag);
        String answer = "";
        KeyczarReader reader = new KeyczarFileReader(locationFlag);
        if (crypterFlag != null) {
            Crypter keyCrypter = new Crypter(crypterFlag);
            reader = new KeyczarEncryptedReader(reader, keyCrypter);
        }
        switch (genericKeyczar.getMetadata().getPurpose()) {
            case DECRYPT_AND_ENCRYPT: {
                Crypter crypter = new Crypter(reader);
                answer = crypter.encrypt(msg);
                break;
            }
            case SIGN_AND_VERIFY: {
                Signer signer = new Signer(reader);
                answer = signer.sign(msg);
                break;
            }
            default: {
                throw new KeyczarException(Messages.getString("KeyczarTool.UnsupportedPurpose", new Object[]{genericKeyczar.getMetadata().getPurpose()}));
            }
        }
        if (destinationFlag == null) {
            System.out.println(answer);
        } else {
            genericKeyczar.writeFile(answer, destinationFlag);
        }
    }

    private static void addKey(String locationFlag, KeyStatus statusFlag, String crypterFlag, KeyParameters keyParams) throws KeyczarException {
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag, crypterFlag);
        genericKeyczar.addVersion(statusFlag, keyParams);
        KeyczarTool.updateGenericKeyczar(genericKeyczar, crypterFlag, locationFlag);
    }

    private static RsaPadding getPadding(String paddingFlag) throws KeyczarException {
        RsaPadding padding = null;
        if (paddingFlag != null) {
            try {
                padding = RsaPadding.valueOf(paddingFlag.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new KeyczarException(Messages.getString("InvalidPadding", paddingFlag));
            }
        }
        return padding;
    }

    private static void create(String locationFlag, String nameFlag, KeyPurpose purposeFlag, String asymmetricFlag) throws KeyczarException {
        KeyMetadata kmd = null;
        if (purposeFlag == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MustDefinePurpose", new Object[0]));
        }
        switch (purposeFlag) {
            case TEST: {
                kmd = new KeyMetadata(nameFlag, KeyPurpose.TEST, DefaultKeyType.TEST);
                break;
            }
            case SIGN_AND_VERIFY: {
                if (asymmetricFlag != null) {
                    if (asymmetricFlag.equalsIgnoreCase("rsa")) {
                        kmd = new KeyMetadata(nameFlag, KeyPurpose.SIGN_AND_VERIFY, DefaultKeyType.RSA_PRIV);
                        break;
                    }
                    if (asymmetricFlag.equalsIgnoreCase("ec")) {
                        kmd = new KeyMetadata(nameFlag, KeyPurpose.SIGN_AND_VERIFY, DefaultKeyType.EC_PRIV);
                        break;
                    }
                    kmd = new KeyMetadata(nameFlag, KeyPurpose.SIGN_AND_VERIFY, DefaultKeyType.DSA_PRIV);
                    break;
                }
                kmd = new KeyMetadata(nameFlag, KeyPurpose.SIGN_AND_VERIFY, DefaultKeyType.HMAC_SHA1);
                break;
            }
            case DECRYPT_AND_ENCRYPT: {
                kmd = asymmetricFlag != null ? new KeyMetadata(nameFlag, KeyPurpose.DECRYPT_AND_ENCRYPT, DefaultKeyType.RSA_PRIV) : new KeyMetadata(nameFlag, KeyPurpose.DECRYPT_AND_ENCRYPT, DefaultKeyType.AES);
            }
        }
        if (kmd == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.UnsupportedPurpose", new Object[]{purposeFlag}));
        }
        if (mock == null) {
            if (locationFlag == null) {
                throw new KeyczarException(Messages.getString("KeyczarTool.MustDefineLocation", new Object[0]));
            }
            File file = new File(locationFlag + "meta");
            if (file.exists()) {
                throw new KeyczarException(Messages.getString("KeyczarTool.FileExists", file));
            }
            try {
                FileOutputStream metaOutput = new FileOutputStream(file);
                metaOutput.write(kmd.toString().getBytes("UTF-8"));
                metaOutput.close();
            }
            catch (IOException e) {
                throw new KeyczarException(Messages.getString("KeyczarTool.UnableToWrite", file.toString()), e);
            }
        } else {
            mock.setMetadata(kmd);
        }
    }

    private static void promote(String locationFlag, int versionFlag) throws KeyczarException {
        if (versionFlag < 0) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MissingVersion", new Object[0]));
        }
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag);
        genericKeyczar.promote(versionFlag);
        KeyczarTool.updateGenericKeyczar(genericKeyczar, locationFlag);
    }

    private static void demote(String locationFlag, int versionFlag) throws KeyczarException {
        if (versionFlag < 0) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MissingVersion", new Object[0]));
        }
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag);
        genericKeyczar.demote(versionFlag);
        KeyczarTool.updateGenericKeyczar(genericKeyczar, locationFlag);
    }

    private static void publicKeys(String locationFlag, String destinationFlag) throws KeyczarException {
        if (mock == null && destinationFlag == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MustDefineDestination", new Object[0]));
        }
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag);
        genericKeyczar.publicKeyExport(destinationFlag);
    }

    private static void revoke(String locationFlag, int versionFlag) throws KeyczarException {
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag);
        genericKeyczar.revoke(versionFlag);
        KeyczarTool.updateGenericKeyczar(genericKeyczar, locationFlag);
        if (mock == null) {
            File revokedVersion = new File(locationFlag + versionFlag);
            if (!revokedVersion.delete()) {
                throw new KeyczarException(Messages.getString("KeyczarTool.UnableToDelete", new Object[0]));
            }
        } else {
            mock.removeKey(versionFlag);
        }
    }

    private static void printUsage() {
        ArrayList<String> usageParams = new ArrayList<String>();
        for (Command command : Command.values()) {
            usageParams.add(command.toString());
        }
        for (Enum enum_ : Flag.values()) {
            usageParams.add(((Flag)enum_).toString());
        }
        System.out.println(Messages.getString("KeyczarTool.Usage", usageParams.toArray()));
    }

    private static GenericKeyczar createGenericKeyczar(String locationFlag) throws KeyczarException {
        return KeyczarTool.createGenericKeyczar(locationFlag, null);
    }

    private static GenericKeyczar createGenericKeyczar(String locationFlag, String crypterFlag) throws KeyczarException {
        if (mock != null) {
            return new GenericKeyczar(mock);
        }
        if (locationFlag == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.NeedLocation", Messages.getString("KeyczarTool.Location", new Object[0])));
        }
        KeyczarReader reader = new KeyczarFileReader(locationFlag);
        if (crypterFlag != null) {
            Crypter keyDecrypter = new Crypter(crypterFlag);
            reader = new KeyczarEncryptedReader(reader, keyDecrypter);
        }
        return new GenericKeyczar(reader);
    }

    private static void updateGenericKeyczar(GenericKeyczar genericKeyczar, String locationFlag) throws KeyczarException {
        KeyczarTool.updateGenericKeyczar(genericKeyczar, null, locationFlag);
    }

    private static void updateGenericKeyczar(GenericKeyczar genericKeyczar, String crypterFlag, String locationFlag) throws KeyczarException {
        if (mock != null) {
            mock.setMetadata(genericKeyczar.getMetadata());
            for (KeyVersion version : genericKeyczar.getVersions()) {
                mock.setKey(version.getVersionNumber(), genericKeyczar.getKey(version));
            }
        } else if (crypterFlag != null) {
            genericKeyczar.writeEncrypted(locationFlag, new Encrypter(crypterFlag));
        } else {
            genericKeyczar.write(locationFlag);
        }
    }
}

