/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.keyczar.KeyMetadata;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.util.Util;

public class KeyczarFileReader
implements KeyczarReader {
    private String location;
    static final String META_FILE = "meta";

    public KeyczarFileReader(String fileLocation) {
        if (fileLocation != null && !fileLocation.endsWith(File.separator)) {
            fileLocation = fileLocation + File.separator;
        }
        this.location = fileLocation;
    }

    public String getKey(int version) throws KeyczarException {
        return this.readFile(this.location + version);
    }

    public String getKey() throws KeyczarException {
        KeyMetadata metadata = KeyMetadata.read(this.getMetadata());
        return this.getKey(metadata.getPrimaryVersion().getVersionNumber());
    }

    public String getMetadata() throws KeyczarException {
        return this.readFile(this.location + META_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String filename) throws KeyczarException {
        String string;
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] contents = Util.readStreamFully(fis);
            string = new String(contents);
        }
        catch (Throwable throwable) {
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new KeyczarException(Messages.getString("KeyczarFileReader.FileError", filename), e);
            }
        }
        fis.close();
        return string;
    }
}

