/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.util.Util;

public class KeyVersion {
    @Expose
    private boolean exportable = false;
    @Expose
    private KeyStatus status = KeyStatus.ACTIVE;
    @Expose
    private int versionNumber = 0;

    private KeyVersion() {
    }

    public KeyVersion(int v, boolean export) {
        this(v, KeyStatus.ACTIVE, export);
    }

    public KeyVersion(int v, KeyStatus s, boolean export) {
        this.versionNumber = v;
        this.status = s;
        this.exportable = export;
    }

    public String toString() {
        return Util.gson().toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeyVersion)) {
            return false;
        }
        KeyVersion v = (KeyVersion)o;
        return this.getVersionNumber() == v.getVersionNumber();
    }

    public int hashCode() {
        return this.versionNumber;
    }

    public KeyStatus getStatus() {
        return this.status;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public void setStatus(KeyStatus status) {
        this.status = status == null ? this.status : status;
    }

    public static KeyVersion read(String jsonString) {
        return (KeyVersion)Util.gson().fromJson(jsonString, KeyVersion.class);
    }
}

