/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyVersion;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.exceptions.NoPrimaryKeyException;
import org.keyczar.interfaces.KeyType;
import org.keyczar.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyMetadata {
    @Expose
    String name = "";
    @Expose
    KeyPurpose purpose = KeyPurpose.TEST;
    @Expose
    KeyType type = DefaultKeyType.TEST;
    @Expose
    List<KeyVersion> versions = new ArrayList<KeyVersion>();
    @Expose
    boolean encrypted = false;
    protected Map<Integer, KeyVersion> versionMap = new HashMap<Integer, KeyVersion>();

    public KeyMetadata() {
    }

    public KeyMetadata(String n, KeyPurpose p, KeyType t) {
        this.name = n;
        this.purpose = p;
        this.type = t;
    }

    public String toString() {
        return Util.gson().toJson((Object)this);
    }

    public boolean addVersion(KeyVersion version) {
        int versionNumber = version.getVersionNumber();
        if (!this.versionMap.containsKey(versionNumber)) {
            this.versionMap.put(versionNumber, version);
            this.versions.add(version);
            return true;
        }
        return false;
    }

    public boolean removeVersion(int versionNumber) {
        if (this.versionMap.containsKey(versionNumber)) {
            KeyVersion version = this.versionMap.get(versionNumber);
            this.versions.remove(version);
            this.versionMap.remove(versionNumber);
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public KeyPurpose getPurpose() {
        return this.purpose;
    }

    public KeyType getType() {
        return this.type;
    }

    void setType(KeyType type) {
        this.type = type;
    }

    void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public KeyVersion getVersion(int versionNumber) {
        return this.versionMap.get(versionNumber);
    }

    public List<KeyVersion> getVersions() {
        return this.versions;
    }

    public KeyVersion getPrimaryVersion() throws NoPrimaryKeyException {
        for (KeyVersion version : this.versions) {
            if (version.getStatus() != KeyStatus.PRIMARY) continue;
            return version;
        }
        throw new NoPrimaryKeyException();
    }

    public static KeyMetadata read(String jsonString) {
        KeyMetadata kmd = (KeyMetadata)Util.gson().fromJson(jsonString, KeyMetadata.class);
        for (KeyVersion version : kmd.getVersions()) {
            kmd.versionMap.put(version.getVersionNumber(), version);
        }
        return kmd;
    }
}

