/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyczarKey;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.keyparams.KeyParameters;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public class HmacKey
extends KeyczarKey {
    private static final String MAC_ALGORITHM = "HMACSHA1";
    private static final int HMAC_DIGEST_SIZE = 20;
    @Expose
    private final String hmacKeyString;
    private SecretKey hmacKey;
    private final byte[] hash = new byte[4];

    public HmacKey(byte[] keyBytes) throws KeyczarException {
        super(keyBytes.length * 8);
        this.hmacKeyString = Base64Coder.encodeWebSafe(keyBytes);
        this.initJceKey(keyBytes);
    }

    private HmacKey() {
        super(0);
        this.hmacKeyString = null;
    }

    static HmacKey generate(KeyParameters params) throws KeyczarException {
        return new HmacKey(Util.rand(params.getKeySize() / 8));
    }

    void initFromJson() throws KeyczarException {
        this.initJceKey(Base64Coder.decodeWebSafe(this.hmacKeyString));
    }

    private void initJceKey(byte[] keyBytes) throws KeyczarException {
        this.hmacKey = new SecretKeySpec(keyBytes, MAC_ALGORITHM);
        System.arraycopy(Util.hash(new byte[][]{keyBytes}), 0, this.hash, 0, this.hash.length);
    }

    byte[] getEncoded() {
        return this.hmacKey.getEncoded();
    }

    protected Stream getStream() throws KeyczarException {
        return new HmacStream();
    }

    public KeyType getType() {
        return DefaultKeyType.HMAC_SHA1;
    }

    protected byte[] hash() {
        return this.hash;
    }

    static HmacKey read(String input) throws KeyczarException {
        HmacKey key = (HmacKey)Util.gson().fromJson(input, HmacKey.class);
        key.initFromJson();
        return key;
    }

    protected SecretKey getJceKey() {
        return this.hmacKey;
    }

    private class HmacStream
    implements VerifyingStream,
    SigningStream {
        private final Mac hmac;

        public HmacStream() throws KeyczarException {
            try {
                this.hmac = Mac.getInstance(HmacKey.MAC_ALGORITHM);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int digestSize() {
            return 20;
        }

        public void initSign() throws KeyczarException {
            try {
                this.hmac.init(HmacKey.this.hmacKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public void initVerify() throws KeyczarException {
            this.initSign();
        }

        public void sign(ByteBuffer output) {
            output.put(this.hmac.doFinal());
        }

        public void updateSign(ByteBuffer input) {
            this.hmac.update(input);
        }

        public void updateVerify(ByteBuffer input) {
            this.updateSign(input);
        }

        public boolean verify(ByteBuffer signature) {
            byte[] sigBytes = new byte[signature.remaining()];
            signature.get(sigBytes);
            return Util.safeArrayEquals(this.hmac.doFinal(), sigBytes);
        }
    }
}

