/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public class DsaPublicKey
extends KeyczarPublicKey {
    private static final String KEY_GEN_ALGORITHM = "DSA";
    private static final String SIG_ALGORITHM = "SHA1withDSA";
    private static final int DSA_DIGEST_SIZE = 48;
    private DSAPublicKey jcePublicKey;
    private final byte[] hash = new byte[4];
    @Expose
    final String y;
    @Expose
    final String p;
    @Expose
    final String q;
    @Expose
    final String g;

    static DsaPublicKey read(String input) throws KeyczarException {
        DsaPublicKey key = (DsaPublicKey)Util.gson().fromJson(input, DsaPublicKey.class);
        key.initFromJson();
        return key;
    }

    DsaPublicKey(DSAPublicKey jcePublicKey) throws KeyczarException {
        this(jcePublicKey.getY(), jcePublicKey.getParams());
    }

    DsaPublicKey(DSAPrivateKey jcePrivateKey) throws KeyczarException {
        this(DsaPublicKey.computeY(jcePrivateKey), jcePrivateKey.getParams());
    }

    private DsaPublicKey() {
        super(0);
        this.jcePublicKey = null;
        this.g = null;
        this.q = null;
        this.p = null;
        this.y = null;
    }

    private DsaPublicKey(BigInteger yVal, DSAParams params) throws KeyczarException {
        super(params.getP().bitLength());
        BigInteger pVal = params.getP();
        BigInteger qVal = params.getQ();
        BigInteger gVal = params.getG();
        this.y = Base64Coder.encodeWebSafe(yVal.toByteArray());
        this.p = Base64Coder.encodeWebSafe(pVal.toByteArray());
        this.q = Base64Coder.encodeWebSafe(qVal.toByteArray());
        this.g = Base64Coder.encodeWebSafe(gVal.toByteArray());
        this.initializeJceKey(yVal, pVal, qVal, gVal);
        this.initializeHash();
    }

    private static BigInteger computeY(DSAPrivateKey jcePrivateKey) {
        BigInteger p = jcePrivateKey.getParams().getP();
        BigInteger g = jcePrivateKey.getParams().getG();
        BigInteger x = jcePrivateKey.getX();
        return g.modPow(x, p);
    }

    protected Stream getStream() throws KeyczarException {
        return new DsaVerifyingStream();
    }

    public KeyType getType() {
        return DefaultKeyType.DSA_PUB;
    }

    public byte[] hash() {
        return this.hash;
    }

    void initFromJson() throws KeyczarException {
        BigInteger yVal = new BigInteger(Base64Coder.decodeWebSafe(this.y));
        BigInteger pVal = new BigInteger(Base64Coder.decodeWebSafe(this.p));
        BigInteger qVal = new BigInteger(Base64Coder.decodeWebSafe(this.q));
        BigInteger gVal = new BigInteger(Base64Coder.decodeWebSafe(this.g));
        this.initializeJceKey(yVal, pVal, qVal, gVal);
        this.initializeHash();
    }

    private void initializeJceKey(BigInteger yVal, BigInteger pVal, BigInteger qVal, BigInteger gVal) throws KeyczarException {
        try {
            KeyFactory kf = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            this.jcePublicKey = (DSAPublicKey)kf.generatePublic(new DSAPublicKeySpec(yVal, pVal, qVal, gVal));
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    private void initializeHash() throws KeyczarException {
        DSAParams dsaParams = this.jcePublicKey.getParams();
        byte[] fullHash = Util.prefixHash(Util.stripLeadingZeros(dsaParams.getP().toByteArray()), Util.stripLeadingZeros(dsaParams.getQ().toByteArray()), Util.stripLeadingZeros(dsaParams.getG().toByteArray()), Util.stripLeadingZeros(this.jcePublicKey.getY().toByteArray()));
        System.arraycopy(fullHash, 0, this.hash, 0, this.hash.length);
    }

    protected PublicKey getJceKey() {
        return this.jcePublicKey;
    }

    protected boolean isSecret() {
        return false;
    }

    private class DsaVerifyingStream
    implements VerifyingStream {
        private Signature signature;

        public DsaVerifyingStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(DsaPublicKey.SIG_ALGORITHM);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int digestSize() {
            return 48;
        }

        public void initVerify() throws KeyczarException {
            try {
                this.signature.initVerify(DsaPublicKey.this.jcePublicKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public void updateVerify(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        public boolean verify(ByteBuffer sig) throws KeyczarException {
            try {
                return this.signature.verify(sig.array(), sig.position(), sig.limit() - sig.position());
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }
    }
}

