(ns circleci.test.split
  (:require [clojure.data.xml :as xml]
            [clojure.java.io :as io]))

(defn- var-name [{:keys [ns name]}]
  (symbol (clojure.core/name ns) (str name)))

(defn- tests-from [root]
  (let [suite (:name (:attrs root))]
    (for [test-case (:content root)]
      (symbol suite (:name (:attrs test-case))))))

(defn- all-tests-in [report-dir]
  (for [report-file (.listFiles (io/file report-dir))
        test (tests-from (xml/parse (io/reader report-file)))]
    test))

(defn- test-set-for [report-dir node-number total-nodes]
  (set (keep-indexed #(and (= node-number (mod %1 total-nodes)) %2)
                     (sort (all-tests-i report-dir)))))

(defn split-selector
  "Return a selector predicate based on previous test results for split run.

Read a list of all the tests and split it into `total-nodes` chunks, then
only run the tests in the chunk assigned to the current process."
  [report-dir node-number total-nodes]
  (comp (test-set-for report-dir node-number total-nodes) var-name))
