# circle-vault

A Clojure library designed to connect to HashiCorp Vault.

## Installation

```
[circleci/circle-vault "0.1.0-SNAPSHOT"]
```

## Usage

```
(require '[circle-vault.core :as vault])

(def url "http://127.0.0.1:8200")
(def role-id "some-role-id")
(def secret-id "some-secret-id")

(def client (vault/vault-client url role-id secret-id))

# Write secret
(vault/write-secret client "secret/foo" {:foo "foo"})

# Read secret
(vault/read-secret client "secret/foo")

# Lookup a token associated with the client
# Make sure you have "read" permission in "auth/token/*"
(vault/token-lookup client)

# Renew a token associated with the client
# Make sure you have "update" permission in "auth/token/*"
(vault/token-renew client)

# Run periodic token-updater in background
(vault/run-token-updater client)
```

## License

Copyright © 2016 CircleCI, All Rights Reserved
