(ns circle-util.walk
  (:require [clojure.string :as string]
            [clojure.walk :as walk]
            hiccup.util))

(defn- ->underscores-map [val]
  (if (and (map? val) (not (-> val meta :preserve-keys)))
    (with-meta
      (->> val
           (map (fn [[k v]] [(when-not (nil? k) (string/replace (name k) \- \_))
                             v]))
           (into {}))
      (meta val))
    val))

(defn ->underscores [resp]
  (if (-> resp meta :preserve-keys-nested)
    resp
    (walk/walk
     (fn [val]
       (if (-> resp meta :preserve-keys-nested)
         val
         (-> val ->underscores-map ->underscores)))
     identity
     (->underscores-map resp))))

(defn escape-html
  "Escapes html for all strings in the given datastructure. Ignores anything with
  {:preserve-html true} metadata, including anything nested under it."
  [resp]
  (if (-> resp meta :preserve-html)
    resp
    (walk/walk
     (fn [val]
       (cond (string? val) (hiccup.util/escape-html val)
             (-> val meta :preserve-html) val
             :else (escape-html val)))
     identity
     resp)))

