(ns circle-util.type.ann
  (:require [clojure.core.typed :as t :refer (ann override-method Option ann-protocol)]
            [clojure.core.typed.contrib-annotations]
            [clojure.java.io]
            [clojure.tools.logging.impl]
            frinj.core
            clj-statsd)
  (:import java.util.regex.Pattern
           (java.io InputStream
                    OutputStream
                    File
                    Reader
                    Writer)
           (java.net InetAddress)
           (clojure.lang
            Named
            Namespace)
           (clojure.tools.logging.impl LoggerFactory Logger)
           (org.joda.time DateTime
                          DateTimeZone
                          Duration
                          Period
                          Years
                          Months
                          Weeks
                          Days
                          Hours
                          Minutes
                          Seconds
                          ReadableInstant
                          ReadablePeriod)
           org.joda.time.format.DateTimeFormatter
           frinj.core.fjv))

(t/defalias SHA1 String)

;; things that clojure.core/name will work on
(t/defalias INamed (t/U String clojure.lang.Named))
;; annotations for things in core/libs we don't own that aren't official yet

(t/non-nil-return java.lang.Process/getOutputStream :all)
(t/non-nil-return java.lang.Runtime/getRuntime :all)
(t/non-nil-return java.lang.Runtime/exec :all)
(t/non-nil-return java.lang.management.ManagementFactory/getRuntimeMXBean :all)
(t/non-nil-return java.lang.Long/parseLong :all)
(t/non-nil-return java.util.regex.Pattern/compile :all)
(t/non-nil-return java.text.Format/format :all)
(t/non-nil-return org.joda.time.DateTimeZone/UTC :all)
(t/non-nil-return org.joda.time.Duration/standardSeconds :all)
(t/non-nil-return org.joda.time.Duration/standardMinutes :all)
(t/non-nil-return org.joda.time.Duration/standardHours :all)

;; All the different implementations of ReadablePeriod
(t/non-nil-return org.joda.time.Period/plus :all)
(t/non-nil-return org.joda.time.Period/minus :all)
(t/non-nil-return org.joda.time.Years/plus :all)
(t/non-nil-return org.joda.time.Years/minus :all)
(t/non-nil-return org.joda.time.Months/plus :all)
(t/non-nil-return org.joda.time.Months/minus :all)
(t/non-nil-return org.joda.time.Weeks/plus :all)
(t/non-nil-return org.joda.time.Weeks/minus :all)
(t/non-nil-return org.joda.time.Days/plus :all)
(t/non-nil-return org.joda.time.Days/minus :all)
(t/non-nil-return org.joda.time.Hours/plus :all)
(t/non-nil-return org.joda.time.Hours/minus :all)
(t/non-nil-return org.joda.time.Minutes/plus :all)
(t/non-nil-return org.joda.time.Minutes/minus :all)
(t/non-nil-return org.joda.time.Seconds/plus :all)
(t/non-nil-return org.joda.time.Seconds/minus :all)

(t/non-nil-return clojure.lang.IRef/getWatches :all)
(t/non-nil-return java.net.InetAddress/getByName :all)
(t/nilable-param java.net.InetAddress/getByName {1 :all})
(t/non-nil-return java.net.InetAddress/getHostAddress :all)
(t/non-nil-return java.net.InetAddress/getHostName :all)
(t/non-nil-return java.net.InetAddress/getLocalHost :all)
(t/non-nil-return java.io.StringWriter/toString :all)

;; START EVIL
(ann clojure.core/include [t/Any -> t/Any])
;; END EVIL

(ann clojure.core/sort-by (t/All [x] [[x -> t/Any] (t/Seq x) -> (t/Seq x)]))

(ann clojure.set/map-invert (t/All [x y]
                                 [(t/Map x y) -> (t/Map y x)]))

(ann clojure.string/escape [String (t/Map Character (t/U Character String)) -> String])
(ann clojure.string/replace (t/IFn [String String String -> String]
                                [String Character Character -> String]
                                [String Pattern (t/U String [t/Any -> String]) -> String]))
(ann clojure.string/trim [String -> String])
(ann clojure.string/lower-case [String -> String])

(ann clojure.pprint/pprint (t/IFn [t/Any -> nil]))
(ann clojure.core/re-pattern [String -> Pattern])
(ann clojure.core/re-matches [Pattern String -> (t/U nil String (t/Vec String))])

(ann clojure.core/slurp [clojure.java.io/IOFactory -> String])
;; TODO, not sure why IOFactory doesn't work here
(ann clojure.core/spit (t/IFn [String t/Any -> nil]
                           [File t/Any -> nil]))

(ann ^:no-check clojure.java.io/copy
     [(t/U InputStream Reader File (Array byte) String)
      (t/U OutputStream Writer File)
      & :optional {:buffer-size t/Int
                   :encoding String}
      -> nil])

(ann clojure.test/*load-tests* Boolean)
(ann clojure.tools.logging/*logger-factory* LoggerFactory)
(ann clojure.tools.logging.impl/get-logger (t/IFn [LoggerFactory (t/U t/Sym Namespace) -> clojure.tools.logging.impl.Logger]))
(ann clojure.tools.logging.impl/enabled? (t/IFn [Logger t/Kw -> Boolean]))
(ann clojure.tools.logging/log* (t/IFn [Logger t/Kw (t/U Throwable nil) String -> nil]))


(ann clojure.core.memoize/memo (t/All [x] [x -> x]))
(ann clojure.core.memoize/memo-clear! (t/All [x]
                                           (t/IFn [[-> t/Any] -> t/Any]
                                               [[x -> t/Any] -> t/Any])))

(ann clojure.core/ancestors (t/IFn [(t/U Class t/Kw t/Sym) -> (t/Seqable (t/U Class t/Kw t/Sym))]
                                   [t/Hierarchy (t/U Class t/Kw t/Sym) -> (t/Seqable (t/U Class t/Kw t/Sym))]))

(ann clojure.core/descendants (t/IFn [(t/U Class t/Kw t/Sym) -> (t/Seqable (t/U Class t/Kw t/Sym))]
                                     [t/Hierarchy (t/U Class t/Kw t/Sym) -> (t/Seqable (t/U Class t/Kw t/Sym))]))


(t/ann clj-time.core/date-time
       (t/IFn [t/Int -> DateTime]
              [t/Int t/Int -> DateTime]
              [t/Int t/Int t/Int -> DateTime]
              [t/Int t/Int t/Int t/Int -> DateTime]
              [t/Int t/Int t/Int t/Int t/Int -> DateTime]
              [t/Int t/Int t/Int t/Int t/Int t/Int  -> DateTime]
              [t/Int t/Int t/Int t/Int t/Int t/Int t/Int -> DateTime]))
(ann clj-time.core/latest
  (t/IFn [ReadableInstant ReadableInstant -> ReadableInstant]
         [(t/Coll ReadableInstant) -> ReadableInstant]))
(ann clj-time.core/now [-> DateTime])
(ann clj-time.format/parse (t/IFn
                            [String -> (Option DateTime)]
                            [(t/U DateTimeFormatter String) String -> (Option DateTime)]))
(ann clj-time.core/millis (t/IFn [t/Int -> Period]))
(ann clj-time.core/seconds (t/IFn [t/Int -> Seconds]))
(ann clj-time.core/minutes (t/IFn [t/Int -> Minutes]))
(ann clj-time.core/hours (t/IFn [t/Int -> Hours]))
(ann clj-time.core/days [Number -> Days])

(ann clj-time.core/in-millis (t/IFn [ReadablePeriod -> t/AnyInteger]))

(ann clj-time.format/formatter (t/IFn [String -> DateTimeFormatter]
                                   [String DateTimeZone -> DateTimeFormatter]
                                   [DateTimeZone String * -> DateTimeFormatter]))

(ann clj-time.coerce/to-long (t/IFn [nil -> nil]
                                 [java.util.Date -> Long]
                                 [java.sql.Date -> Long]
                                 [java.sql.Date -> Long]
                                 [DateTime -> Long]
                                 [Integer -> Long]
                                 [String -> (t/U Long nil)]
                                 [java.sql.Timestamp -> Long]))
(ann clj-time.core/after? [DateTime DateTime -> Boolean])
(ann clj-time.core/ago [ReadablePeriod -> DateTime])
(ann clj-time.core/before? [DateTime DateTime -> Boolean])
(ann clj-time.core/from-now [ReadablePeriod -> DateTime])
(ann clj-time.core/plus [DateTime ReadablePeriod -> DateTime])
(ann clj-time.core/minus [DateTime ReadablePeriod -> DateTime])

(t/ann clj-statsd/gauge (t/IFn [(t/U t/Keyword String) Number -> t/Any]
                               [(t/U t/Keyword String) Number t/Any -> t/Any]))
(t/ann clj-statsd/increment (t/IFn [(t/U t/Keyword String) -> t/Any]
                                   [(t/U t/Keyword String) Number -> t/Any]
                                   [(t/U t/Keyword String) Number t/Any -> t/Any]))

(t/defalias MongoRow (t/HMap :mandatory {:_id t/Kw}))

(ann fs/join [String * -> String])
(ann fs/split [String -> (t/Seq String)])
(ann fs/mkdirs [String -> t/Any])
(ann fs/cwd [-> String])
(ann fs/tempfile [-> String])
(ann fs/chmod [String String -> t/Any])
(ann fs/delete [String -> t/Any])
(ann fs/size [String -> Long])

(t/defalias CljHttpResponse (t/HMap :mandatory {:status t/Int
                                                :headers (t/Map String String)}))
(ann clj-http.client/get (t/IFn
                          [String -> CljHttpResponse]
                          [String (t/Map t/Kw t/Any) -> CljHttpResponse]))

(t/defalias SlingshotContext (t/HMap :mandatory {:throwable Throwable
                                                 :object t/Any
                                                 :message String}
                                     :optional {:cause Throwable
                                                :environment t/Any
                                                :catch-hook-throw t/Any
                                                :catch-hook-rethrow t/Any}
                                     :absent-keys #{:catch-hook-return}))

(ann slingshot.support/*throw-hook* [SlingshotContext -> nil])
(ann slingshot.support/*catch-hook* [SlingshotContext -> SlingshotContext])
(ann slingshot.support/get-context [Throwable -> SlingshotContext])
(ann slingshot.support/throw-context [t/Any String (t/Seqable t/Any) t/Any t/Any -> t/Nothing])
(ann slingshot.support/stack-trace [-> (Array StackTraceElement)])


(ann amazonica.core/defcredential [String String -> t/Any])
(ann amazonica.aws.identitymanagement/list-user-policies
     [(t/HMap :mandatory {:user-name String}) -> (t/HMap :mandatory {:policy-names (t/Seq String)})])


(ann clojure.core/group-by (t/All [x y] [[x -> y] (t/Option (t/Seq x)) -> (t/Map y (t/Vec x))]))

;; built-in signature is wrong
(ann clojure.core/vals
     (t/All [v]
            (t/IFn [(t/Map t/Any v) -> (t/Seq v) :object {:path [Vals], :id 0}]
                   [nil -> nil])))

(ann environ.core/env [t/Kw -> (t/Option String)])

(ann clojure.core/not-empty (t/All [x]
                                   ;; TODO: Tighten bounds
                                   [(t/Option x) -> (t/Option x)]))
