(ns circle-util.smoke-test
  "Require all test namespaces, to make sure they compile.

  Usage:
  lein run -m circle-util.smoke-test"
  (:require [bultitude.core :as bultitude])
  (:import java.io.File))


(defn print-require [ns]
  (println "requiring" ns)
  (require ns))

(defn require-all-tests []
  (doseq [ns (bultitude/namespaces-in-dir (File. "test/"))]
    (print-require ns)))

(defn require-all-src-files []
  (doseq [ns (bultitude/namespaces-in-dir (File. "src/"))]
    (print-require ns)))

(defn smoke-test []
  (require-all-src-files)
  (require-all-tests))

(defn -main []
  (try (smoke-test)
       (println "all good!")
       (System/exit 0)
       (catch Throwable t
         (.printStackTrace t)
         (System/exit 1))))
