(ns circle-util.json
  (:require [clj-time.format :as format-time]
            [cheshire.core :as json]
            [cheshire.generate :as generate]
            [circle-util.walk :as c-walk]
            [circle-util.core :refer (defn-once)]))

(defn ->json
  [body & {:keys [pretty] :or {pretty false}}]
  (-> body
      c-walk/->underscores
      (json/encode {:pretty pretty})))

(defn ->iso-8601 [date]
  (format-time/unparse (format-time/formatters :date-time) date))

(defn-once init
  "Adds a date encoder to the Cheshire config that formats all emitted
  dates using `->iso-8601`."
  []
  (generate/add-encoder org.joda.time.DateTime
                        (fn [date json-generator]
                          (generate/encode-str (->iso-8601 date) json-generator))))

;; TODO this is library code now, so it shouldn't be doing doing such
;; side-effecty things during ns load. But for now, all callers expect
;; this to be installed, so until we come up with a better solution,
;; leaving this here.

(init)
