(ns circle-util.except
  (:require [clojure.core.typed :as t]
            [slingshot.support]
            [slingshot.slingshot :refer (throw+)]
            [circle-util.type.ann :as ann]))

(t/warn-on-unannotated-vars)

(t/ann ^:no-check throwf [String t/Any * -> nil])
(defn throwf [fmt & args]
  (throw (Exception. (apply format fmt args))))

(defmacro throw-if [test & format-args]
  `(do
     (let [resp# (do ~test)]
       (when resp#
         (throwf ~@format-args))
       (assert (not resp#)))))

(defmacro throw-if+ [test data str & format]
  `(do
     (let [resp# (do ~test)]
       (when resp#
         (throw+ ~data ~str ~@format))
       (assert (not resp#)))))

(defmacro throw-if-not [test & format-args]
  `(do
     (let [resp# (do ~test)]
       (when (not resp#)
         (throwf ~@format-args))
       (assert resp#))))

(defmacro throw-if-not+ [test data str & format]
  `(when (not ~test)
     (throw+ ~data ~str ~@format)))

(defmacro eat
  "Executes body, catching all exceptions. Returns the result of body,
  or nil if exceptions where caught"
  [& body]
  `(try
     (do ~@body)
     (catch Exception e#
       nil)))

(defmacro assert!
  "Asserts expr is truthy. Returns expr on success, or throws msg"
  [expr & msg]
  `(let [r# ~expr]
     (assert r# (or ~@msg (format "%s returned %s" (quote ~expr) r#)))
     r#))

(t/ann assert-str! (t/IFn [t/Any -> String]))
(defn assert-str! [expr]
  (assert (string? expr))
  expr)

(t/ann ^:no-check expected-exception? [(t/U ann/SlingshotContext Throwable) -> Boolean])
(defn expected-exception?
  "True if this is the expected exception.

  Tests that are expected to throw use
  circle.test-utils/throw-expected-exception. Use this to decide
  whether or not to e.g. log. Useful to keep exceptions out of the
  logs when testing, so All Stacktraces Are Bad."
  [throw-context]
  (-> throw-context :object :type (= :expected-exception)))

(defn ╯°□°）╯︵┻━┻ []
  (throw+ {:tableflip true}))
