(ns circle-util.env
  (:require [clojure.core.typed :as t]))

(t/warn-on-unannotated-vars)

(t/ann getenv [String -> (t/Option String)])
(defn getenv [env-var]
  (System/getenv env-var))

(defmacro with-environment-override
  [env-var-map & body]
  `(with-redefs [getenv #(get ~env-var-map %)]
     ~@body))

(t/ann env-var (t/U t/Kw nil))
(def ^:dynamic env-var nil)

(t/ann init-env [-> t/Kw])
(defn init-env
  "The environment this JVM started in. Not necessarily the one it is currently, if testing, for example"
  []
  (or
   env-var
   (when-let [s (getenv "CIRCLE_ENV")]
     (keyword s))
   :development))

(t/ann env [-> t/Kw])
(defn env
  "The current environment we're in"
  []
  (or
   env-var
   (init-env)))

(t/ann production? [-> Boolean])
(defn production? []
  (= (env) :production))

(t/ann staging? [-> Boolean])
(defn staging? []
  (= (env) :staging))

(t/ann test? [-> Boolean])
(defn test? []
  (= (env) :test))

(t/ann development? [-> Boolean])
(defn development? []
  (= (env) :development))
