(ns circle-util.capabilities
  (:require [clojure.string :as str]
            [clojure.core.typed :as t]
            [circle-util.core :refer (defn-once)]
            [circle-util.sh :as sh]
            [circle-util.aws.ec2-metadata :as ec2-metadata]))

;; TODO: port the rest of this namesapce, if we need it.

(t/warn-on-unannotated-vars)

(t/ann real-hostname [-> String])
(defn-once real-hostname
  "hostname of the box"
  []
  (-> (sh/sh "hostname")
      :out
      (str/trim)))

(t/ann hostname [-> String])
(defn-once hostname []
  (or (ec2-metadata/self-instance-id) (real-hostname)))
