(ns ciir.utils
  ^{:author "David Smith"}
  (:import (java.io File)
	   (java.util ArrayList Properties)
	   (java.util.zip GZIPInputStream GZIPOutputStream)))

(defn gzreader [x]
  (-> x
      java.io.FileInputStream.
      GZIPInputStream.
      java.io.InputStreamReader.
      java.io.BufferedReader.))

(defn bzreader [x]
  (-> x
      java.io.FileInputStream.
      org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream.
      java.io.InputStreamReader.
      java.io.BufferedReader.))

(defn take-to-first
  "Returns a lazy sequence of successive items from coll up to
  and including the point at which it (pred item) returns true.
  pred must be free of side-effects."
  [pred coll]
  (lazy-seq
   (when-let [s (seq coll)]
     (if-not (pred (first s))
       (cons (first s) (take-to-first pred (rest s)))
       (list (first s))))))

(defn partition-when
  "Applies f to each value in coll, splitting it each time f returns
   true. Returns a lazy seq of lazy seqs."
  [f coll]
  (when-let [s (seq coll)]
    (lazy-seq
     (let [run (take-to-first f s)
	   res (drop (count run) s)]
       (cons run (partition-when f res))))))

;; from str-utils2
(defn ^String map-str
  "Apply f to each element of coll, concatenate all results into a
  String."
  [f coll]
  (apply str (map f coll)))

(defn partition-str
  "Splits the string into a lazy sequence of substrings, alternating
  between substrings that match the patthern and the substrings
  between the matches.  The sequence always starts with the substring
  before the first match, or an empty string if the beginning of the
  string matches.

  For example: (partition \"abc123def\" #\"[a-z]+\")
  returns: (\"\" \"abc\" \"123\" \"def\")"
  [^String s ^Pattern re]
  (let [m (re-matcher re s)]
    ((fn step [prevend]
       (lazy-seq
        (if (.find m)
          (cons (.subSequence s prevend (.start m))
                (cons (re-groups m)
                      (step (+ (.start m) (count (.group m))))))
          (when (< prevend (.length s))
            (list (.subSequence s prevend (.length s)))))))
     0)))
