/*
 * Decompiled with CFR 0.152.
 */
package cidernrepl0470.difflib;

import cidernrepl0470.difflib.Chunk;
import cidernrepl0470.difflib.PatchFailedException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Delta<T> {
    private Chunk<T> original;
    private Chunk<T> revised;

    public Delta(Chunk<T> original, Chunk<T> revised) {
        if (original == null) {
            throw new IllegalArgumentException("original must not be null");
        }
        if (revised == null) {
            throw new IllegalArgumentException("revised must not be null");
        }
        this.original = original;
        this.revised = revised;
    }

    public abstract void verify(List<T> var1) throws PatchFailedException;

    public abstract void applyTo(List<T> var1) throws PatchFailedException;

    public abstract void restore(List<T> var1);

    public abstract TYPE getType();

    public Chunk<T> getOriginal() {
        return this.original;
    }

    public void setOriginal(Chunk<T> original) {
        this.original = original;
    }

    public Chunk<T> getRevised() {
        return this.revised;
    }

    public void setRevised(Chunk<T> revised) {
        this.revised = revised;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
        result = 31 * result + (this.revised == null ? 0 : this.revised.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Delta other = (Delta)obj;
        if (this.original == null ? other.original != null : !this.original.equals(other.original)) {
            return false;
        }
        return !(this.revised == null ? other.revised != null : !this.revised.equals(other.revised));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        CHANGE,
        DELETE,
        INSERT;

    }
}

