/*
 * Decompiled with CFR 0.152.
 */
package cidernrepl0380.mx.cider.orchard;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LruMap<K, V>
implements Map<K, V> {
    private final LruMapImpl<K, V> delegate;
    private final ReadWriteLock read_write_lock;

    public LruMap(int n) {
        this.delegate = new LruMapImpl(n);
        this.read_write_lock = new ReentrantReadWriteLock();
    }

    @Override
    public int size() {
        int n;
        this.read_write_lock.readLock().lock();
        try {
            n = this.delegate.size();
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        this.read_write_lock.readLock().lock();
        try {
            bl = this.delegate.isEmpty();
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return bl;
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl;
        this.read_write_lock.readLock().lock();
        try {
            bl = this.delegate.containsKey(object);
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return bl;
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl;
        this.read_write_lock.readLock().lock();
        try {
            bl = this.delegate.containsValue(object);
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return bl;
    }

    @Override
    public V get(Object object) {
        Object v;
        this.read_write_lock.readLock().lock();
        try {
            v = this.delegate.get(object);
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        V v2;
        this.read_write_lock.writeLock().lock();
        try {
            v2 = this.delegate.put(k, v);
        }
        finally {
            this.read_write_lock.writeLock().unlock();
        }
        return v2;
    }

    @Override
    public V remove(Object object) {
        Object v;
        this.read_write_lock.writeLock().lock();
        try {
            v = this.delegate.remove(object);
        }
        finally {
            this.read_write_lock.writeLock().unlock();
        }
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        this.read_write_lock.writeLock().lock();
        try {
            this.delegate.putAll(map2);
        }
        finally {
            this.read_write_lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.read_write_lock.writeLock().lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.read_write_lock.writeLock().unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        Set set;
        this.read_write_lock.readLock().lock();
        try {
            set = this.delegate.keySet();
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        Collection collection;
        this.read_write_lock.readLock().lock();
        try {
            collection = this.delegate.values();
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set;
        this.read_write_lock.readLock().lock();
        try {
            set = this.delegate.entrySet();
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return set;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        this.read_write_lock.readLock().lock();
        try {
            bl = this.delegate.equals(object);
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return bl;
    }

    @Override
    public int hashCode() {
        int n;
        this.read_write_lock.readLock().lock();
        try {
            n = this.delegate.hashCode();
        }
        finally {
            this.read_write_lock.readLock().unlock();
        }
        return n;
    }

    private class LruMapImpl<KK, VV>
    extends LinkedHashMap<KK, VV> {
        private final int max_size;

        public LruMapImpl(int n) {
            super(16, 0.75f, true);
            this.max_size = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<KK, VV> entry) {
            return this.size() > this.max_size;
        }
    }
}

