(ns ^{:mranderson/inlined true} cider.nrepl.inlined-deps.rewrite-clj.v1v0v605-alpha.rewrite-clj.zip.insert
  (:require [cider.nrepl.inlined-deps.rewrite-clj.v1v0v605-alpha.rewrite-clj.custom-zipper.core :as zraw]
            [cider.nrepl.inlined-deps.rewrite-clj.v1v0v605-alpha.rewrite-clj.node.protocols :as node]
            [cider.nrepl.inlined-deps.rewrite-clj.v1v0v605-alpha.rewrite-clj.node.whitespace :as nwhitespace]
            [cider.nrepl.inlined-deps.rewrite-clj.v1v0v605-alpha.rewrite-clj.zip.whitespace :as zwhitespace]))

#?(:clj (set! *warn-on-reflection* true))

(def ^:private space
  (nwhitespace/spaces 1))

(defn- insert
  "Generic insertion helper. If the node reached by `move-fn`
   is a whitespace, insert an additional space."
  [move-fn insert-fn prefix zloc item]
  (let [item-node (node/coerce item)
        next-node (move-fn zloc)]
    (->> (concat
           (when (and next-node (not (zwhitespace/whitespace? next-node)))
             [space])
           [item-node]
           (when (not (zwhitespace/whitespace? zloc))
             prefix))
         (reduce insert-fn zloc))))

(defn insert-right
  "Return zipper with `item` inserted to the right of the current node in `zloc`, without moving location.
  Will insert a space if necessary."
  [zloc item]
  (insert
    zraw/right
    zraw/insert-right
    [space]
    zloc item))

(defn insert-left
  "Return zipper with `item` inserted to the left of the current node in `zloc`, without moving location.
  Will insert a space if necessary."
  [zloc item]
  (insert
    zraw/left
    zraw/insert-left
    [space]
    zloc item))

(defn insert-child
  "Return zipper with `item` inserted as the first child of the current node in `zloc`, without moving location."
  [zloc item]
  (insert
    zraw/down
    zraw/insert-child
    []
    zloc item))

(defn append-child
  "Return zipper with `item` inserted as the last child of the current node in `zloc`, without moving.
  Will insert a space if necessary."
  [zloc item]
  (insert
    #(some-> % zraw/down zraw/rightmost)
    zraw/append-child
    []
    zloc item))
