(ns cider.nrepl.middleware.complete
  "Code completion middleware.
  Delegates to the compliment library for the heavy lifting.
  Uses clj-suitable for ClojureScript completion."
  (:require
   [cider.nrepl.middleware.util.cljs :as cljs]
   [cider.nrepl.middleware.util.error-handling :refer [with-safe-transport]]
   [cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.core :as complete]
   [cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.utils :as complete-utils]
   [cider.nrepl.inlined-deps.orchard.v0v6v1.orchard.misc :as misc]
   [cider.nrepl.inlined-deps.suitable.v0v3v5.suitable.compliment.sources.cljs :as suitable-sources]))

(def clj-sources
  "Source keywords for Clojure completions."
  [:cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.special-forms/literals
   :cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.class-members/static-members
   :cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.ns-mappings/ns-mappings
   :cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.resources/resources
   :cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.keywords/keywords
   :cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.local-bindings/local-bindings
   :cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.class-members/members
   :cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.namespaces-and-classes/namespaces-and-classes
   :cider.nrepl.inlined-deps.compliment.v0v3v11.compliment.sources.special-forms/special-forms])

(def cljs-sources
  "Source keywords for ClojureScript completions."
  [::suitable-sources/cljs-source])

(defn complete
  [{:keys [ns prefix symbol context extra-metadata enhanced-cljs-completion?] :as msg}]
  ;; TODO: Drop legacy symbol param in version 1.0
  (let [prefix (str (or prefix symbol))
        completion-opts {:ns (misc/as-sym ns)
                         :context context
                         :extra-metadata (set (map keyword extra-metadata))}]
    (if-let [cljs-env (cljs/grab-cljs-env msg)]
      (binding [suitable-sources/*compiler-env* cljs-env]
        (complete/completions prefix (merge completion-opts {:sources cljs-sources})))
      (complete/completions prefix (merge completion-opts {:sources clj-sources})))))

(defn completion-doc
  [{:keys [ns sym symbol] :as msg}]
  ;; TODO: Drop legacy symbol param in version 1.0
  (let [sym (str (or sym symbol))
        ns (misc/as-sym ns)]
    (if-let [cljs-env (cljs/grab-cljs-env msg)]
      (binding [suitable-sources/*compiler-env* cljs-env]
        (complete/documentation sym ns {:sources cljs-sources}))
      (complete/documentation sym ns {:sources clj-sources}))))

(defn complete-reply [msg]
  {:completions (complete msg)})

(defn doc-reply
  [msg]
  {:completion-doc (completion-doc msg)})

(defn flush-caches-reply
  [msg]
  (complete-utils/flush-caches)
  {})

(defn handle-complete [handler msg]
  (with-safe-transport handler msg
    "complete" complete-reply
    "complete-doc" doc-reply
    "complete-flush-caches" flush-caches-reply))
