(ns ^:no-doc mranderson049.cljfmt.v0v6v4.rewrite-clj.v0v6v0.rewrite-clj.node.token
  (:require [mranderson049.cljfmt.v0v6v4.rewrite-clj.v0v6v0.rewrite-clj.node.protocols :as node]))

;; ## Node

(defrecord TokenNode [value string-value]
  node/Node
  (tag [_] :token)
  (printable-only? [_] false)
  (sexpr [_] value)
  (length [_] (count string-value))
  (string [_] string-value)

  Object
  (toString [this]
    (node/string this)))

(node/make-printable! TokenNode)

;; ## Constructor

(defn token-node
  "Create node for an unspecified EDN token."
  [value & [string-value]]
  (->TokenNode
    value
    (or string-value (pr-str value))))
