(ns
  ^{:added "0.4.0"}
  mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node
  (:require [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node
             coerce
             comment
             fn
             forms
             integer
             keyword
             meta
             protocols
             quote
             reader-macro
             regex
             seq
             string
             token
             uneval
             whitespace]
            [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.potemkin :refer [import-vars]]))

;; ## API Facade

(import-vars
  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.protocols
   coerce
   children
   child-sexprs
   concat-strings
   inner?
   leader-length
   length
   printable-only?
   replace-children
   sexpr
   sexprs
   string
   tag]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.comment
   comment-node
   comment?]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.fn
   fn-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.forms
   forms-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.integer
   integer-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.keyword
   keyword-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.meta
   meta-node
   raw-meta-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.regex
   regex-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.reader-macro
   deref-node
   eval-node
   reader-macro-node
   var-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.seq
   list-node
   map-node
   set-node
   vector-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.string
   string-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.quote
   quote-node
   syntax-quote-node
   unquote-node
   unquote-splicing-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.token
   token-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.uneval
   uneval-node]

  [mranderson049.cljfmt.v0v6v1.rewrite-clj.v0v6v0.rewrite-clj.node.whitespace
   comma-separated
   line-separated
   linebreak?
   newlines
   newline-node
   spaces
   whitespace-node
   whitespace?
   comma-node
   comma?
   whitespace-nodes])

;; ## Predicates

(defn whitespace-or-comment?
  "Check whether the given node represents whitespace or comment."
  [node]
  (or (whitespace? node)
      (comment? node)))

;; ## Value

(defn ^{:deprecated "0.4.0"} value
  "DEPRECATED: Get first child as a pair of tag/sexpr (if inner node),
   or just the node's own sexpr. (use explicit analysis of `children`
   `child-sexprs` instead) "
  [node]
  (if (inner? node)
    (some-> (children node)
            (first)
            ((juxt tag sexpr)))
    (sexpr node)))
