(ns cider.inlined-deps.cljfmt.v0v6v1.rewrite-cljs.v0v4v4.rewrite-clj.node.token
  (:require [cider.inlined-deps.cljfmt.v0v6v1.rewrite-cljs.v0v4v4.rewrite-clj.node.protocols :as node]))

;; ## Node

(defrecord TokenNode [value string-value]
  node/Node
  (tag [_] :token)
  (printable-only? [_] false)
  (sexpr [_] value)
  (length [_] (.-length string-value))
  (string [_] string-value)

  Object
  (toString [this]
    (node/string this)))

; TODO
;(node/make-printable! TokenNode)

;; ## Constructor

(defn token-node
  "Create node for an unspecified EDN token."
  ([value]
   (token-node value (pr-str value)))
  ([value string-value]
  (->TokenNode value string-value)))
