; Copyright (C) 2015 Dr. Thomas Schank  (DrTom@schank.ch, Thomas.Schank@algocon.ch)
; Licensed under the terms of the GNU Affero General Public License v3.
; See the "LICENSE.txt" file provided with this software.

(ns cider-ci.open-session.signature
  (:require
    [pandect.core :refer [sha256-hmac-bytes]]
    [clojure.string :refer [split]]
    [clojure.data.json :as json]
    )
  (:import
    [java.util Arrays]
    ))

(defn create [secret message]
  (sha256-hmac-bytes message secret))

(defn valid? [signature secret message]
  (Arrays/equals signature
                 (sha256-hmac-bytes message secret)))

(defn validate! [signature secret message]
  (when-not (valid? signature secret message)
    (throw (IllegalStateException. "Signature validation failed!"))))
