; Copyright (C) 2015 Dr. Thomas Schank  (DrTom@schank.ch, Thomas.Schank@algocon.ch)
; Licensed under the terms of the GNU Affero General Public License v3.
; See the "LICENSE.txt" file provided with this software.

(ns cider-ci.open-session.encoder
  (:refer-clojure :exclude [encode decode])
  (:import
    [java.util Base64]
    [java.security SecureRandom]
    ))

(def encoder (Base64/getUrlEncoder))
(def decoder (Base64/getUrlDecoder))

(defn decode [s]
  (.decode decoder s))

(defn encode [ba]
  (.encodeToString encoder ba))


(defprotocol Encoder
  (encode [x])
  (decode [x]))

(extend-protocol Encoder

  (Class/forName "[B")
  (encode [ba]
    (.encodeToString encoder ba))

  String
  (encode [s]
    (encode (.getBytes s "UTF-8")))
  (decode [s]
    (.decode decoder (.getBytes s "UTF-8"))))



