(ns ch.deepimpact.CasThrottle
  (:require [ch.deepimpact.cas-throttle-api :as api])
  (:gen-class
   :init init
   :state state
   :methods [[exceedsThreshold [javax.servlet.ServletRequest] Boolean]
             [recordSubmissionFailure [javax.servlet.ServletRequest] void]
             [afterCompletion [javax.servlet.ServletRequest] void]
             [clean [] void]]))


;; 1. after completition
;; 2. exceeds?
;; 3.1: fail => after-completition
;; 3.1: success => after-completition

;; loop=> .... clean

(defn -init []
  (println "INIT ch.deepimpact.CasThrottle")

  [[]
   (atom {}) ]

  )


(defn -exceedsThreshold [this req]
  (let [r (Boolean. (api/exceeds-threshold (.state this) req))]
    (println "exceedsThreshold " r)

    r
    ))

(defn -recordSubmissionFailure [this req]
  (let [r (api/record-submission-failure (.state this) req)]
    (println "record-submission-failure" (count @(.state this)) @(.state this))
    r
    )
  )

(defn -afterCompletion [this req]
  (println "afterCompletion" (count @(.state this)) @(.state this))
  (api/after-completion (.state this) req))

(defn -clean [this]
  (println "clean")
  (api/clean (.state this))
  )
