(ns ch.codesmith.blocks.test-containers.vault
  (:require [clj-test-containers.core :as tc]))

(defn vault-container
  ([]
   (vault-container {}))
  ([{:keys [image-name exposed-ports root-token-id]
     :or   {image-name    "hashicorp/vault:1.19"
            exposed-ports [8200]
            root-token-id "token"}}]
   (tc/create {:image-name    image-name
               :exposed-ports exposed-ports
               :env-vars      {"VAULT_DEV_ROOT_TOKEN_ID" root-token-id}
               :wait-for      {:wait-strategy   :log
                               :message         "so you can immediately begin using Vault"
                               :startup-timeout 30}})))

(defn client-config
  [vault-container]
  {:url        (str "http://localhost:" ((:mapped-ports vault-container) 8200))
   :creds-type :token
   :creds      (-> vault-container
                 :env-vars
                 (get "VAULT_DEV_ROOT_TOKEN_ID"))})

;; TODO@stan -> refactor for helper.
;; or as part of a system!
(defmacro with-vault [[var settings] & body]
  `(let [~var (-> (vault-container ~settings)
                (tc/start!))]
     (try
       ~@body
       (finally
         (tc/stop! ~var)))))
