(ns ch.codesmith.blocks.sqlite
  (:require [ch.codesmith.blocks.core :as cb]
            [ch.codesmith.blocks.jdbc :as cbjdbc]
            [clojure.spec.alpha :as s]))

(derive ::datasource cbjdbc/jdbc-datasource)

(def datasource-defaults
  {:datasource {:maximumPoolSize 1}})

(defmulti check-config ::type)

(s/def ::file string?)
(s/def ::file-config (s/keys :req-un [::file]))

(defmethod check-config :file
  [config]
  (cb/check ::file-config config))

(s/def ::name string?)
(s/def ::memory-config (s/keys :opt-un [::name]))

(defmethod check-config :memory
  [config]
  (cb/check ::memory-config config))

(defmulti jdbc-url ::type)

(defmethod jdbc-url :file
  [{:keys [file]}]
  (str "jdbc:sqlite:file:" file))

(defmethod jdbc-url :memory
  [{:keys [name] :or {name "memdb"}}]
  (str "jdbc:sqlite:file:" name "?mode=memory&cache=shared"))

; TODO@stan: use db-specs as well.
(defmethod cb/start-block! ::datasource [_ _ config _]
  (let [config (check-config (cb/deep-merge datasource-defaults config))
        config (assoc config :datasource {:jdbcUrl (jdbc-url config)})]
    (cbjdbc/start-hikaricp-pool! config)))

(defmethod cb/stop-block! ::datasource [_ instance]
  (cbjdbc/halt! instance))
