(ns ch.codesmith.blocks.reitit
  (:require [muuntaja.core :as m]
            [reitit.coercion.malli :as rcm]
            [reitit.ring :as ring]
            [reitit.ring.coercion :as rrcoerce]
            [reitit.ring.middleware.exception :as rrme]
            [reitit.ring.middleware.muuntaja :as rrmm]
            [reitit.ring.middleware.parameters :as rrpa]))

(defn default-e-handler
  "Default safe handler for any exception."
  [^Exception e _]
  {:status 500
   :body   {:type  "exception"
            :class (.getName (.getClass e))}})

(def default-middleware-stack
  [rrmm/format-negotiate-middleware
   rrmm/format-response-middleware
   (rrme/create-exception-middleware (assoc rrme/default-handlers
                                       ::rrme/default default-e-handler))
   rrmm/format-request-middleware
   rrpa/parameters-middleware
   rrcoerce/coerce-exceptions-middleware
   rrcoerce/coerce-request-middleware
   rrcoerce/coerce-response-middleware])

(defn static-router [{:keys [routes-fn middleware-stack]
                      :or   {middleware-stack default-middleware-stack}}]
  (ring/router (routes-fn)
               {:data {:coercion   rcm/coercion
                       :muuntaja   (m/create)
                       :middleware middleware-stack}}))

(defmulti router (fn [_ config]
                   (:type config)))

(defmethod router :static
  [_ config]
  {:instance (static-router config)})

(defn ring-handler [_ {:keys [router default-handler options]}]
  {:instance (ring/ring-handler router default-handler options)})
