(ns ch.codesmith.blocks.rabbitmq
  (:require [ch.codesmith.blocks :as cb]
            [langohr.core :as rmq]))

(defmulti rabbitmq (fn [_ config]
                     (::cb/type config)))

(defmethod rabbitmq :external
  [_ config]
  {::cb/instance (rmq/connect (:settings config))
   ::cb/halt     (fn [_ instance]
                   (rmq/close instance))})
