(ns ch.codesmith.blocks.rabbitmq
  (:require [ch.codesmith.blocks :as cb]
            [ch.codesmith.blocks.config :as cbc]
            [integrant.core :as ig]
            [langohr.core :as rmq]))

(defmethod cb/typed-block-transform
  [::rabbitmq :external]
  [block-key _ ig-config]
  (assoc ig-config block-key {:settings (ig/ref [::cbc/config [block-key :settings]])}))

(defmethod ig/init-key
  ::external
  [_ {:keys [settings]}]
  (rmq/connect settings))

(defmethod ig/halt-key!
  ::external
  [_ connection]
  (rmq/close connection))

(derive ::external ::rabbitmq)
