(ns ch.codesmith.blocks.rabbitmq.dev
  (:require [ch.codesmith.blocks :as cb]
            [ch.codesmith.blocks.rabbitmq :as cbr]
            [ch.codesmith.blocks.test-containers.rabbitmq :as tcr]
            [clj-test-containers.core :as tc]
            [langohr.core :as rmq]))

(def rabbitmq cbr/rabbitmq)

(defn start-rabbitmq-test-container []
  (let [rabbitmq-container (-> (tcr/rabbitmq-container {})
                               (tc/start!))]
    {:container  rabbitmq-container
     :connection (rmq/connect (tcr/connection-settings rabbitmq-container))}))

(defmethod cbr/rabbitmq :dev
  [_ _]
  {:instance         (start-rabbitmq-test-container)
   :resolve-instance :connection
   :halt             (fn [_ {:keys [container connection]}]
                       (rmq/close connection)
                       (tc/stop! container))})

(defn open-admin-web-ui
  [system-instance block-key]
  (-> system-instance
      (cb/get-block block-key)
      :instance
      :container
      tcr/open-admin-web-ui))
