(ns ch.codesmith.blocks.rabbitmq.dev
  (:require [ch.codesmith.blocks.core :as cb]
            [ch.codesmith.blocks.test-containers.rabbitmq :as tcr]
            [clj-test-containers.core :as tc]
            [langohr.core :as rmq]))

(defmethod cb/start-block! ::test-container-connection [_ _ _ _]
  (let [rabbitmq-container (-> (tcr/rabbitmq-container {})
                             (tc/start!))]
    {:container  rabbitmq-container
     :connection (rmq/connect (tcr/connection-config rabbitmq-container))}))

(defmethod cb/resolve-block ::test-container-connection [_ instance]
  (:connection instance))

(defmethod cb/stop-block! ::test-container-connection [_ {:keys [container connection]}]
  (rmq/close connection)
  (tc/stop! container))

(derive ::test-container-connection :rmq/connection)

;; TODO: solve with expension / explicit test container.
#_(defn open-admin-web-ui
    [system]
    (-> system
      (cb/block :rmq/connection)
      :container
      tcr/open-admin-web-ui))
